/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.base.sign.application.service;

import cn.com.yusys.yusp.pay.base.sign.application.dto.ProtoSignReqDto;
import cn.com.yusys.yusp.pay.base.sign.domain.constant.ProtoTypeEnum;
import cn.com.yusys.yusp.pay.base.sign.domain.entity.SignValid;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBCnapsAgentpayProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBCup2AuthpayProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBCup2DebtransferProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBIbpsAcctselProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBIbpsAuthpayProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBMpsAcctselProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBMpsAgentpayProtoinfoService;
import cn.com.yusys.yusp.pay.base.sign.domain.service.data.UsBMpsAuthpayProtoinfoService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.util.YuinLogUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class ProtoSignService {
    @Autowired
    private UsBCnapsAgentpayProtoinfoService usBCnapsAgentpayProtoinfoService;
    @Autowired
    private UsBIbpsAcctselProtoinfoService usBIbpsAcctselProtoinfoService;
    @Autowired
    private UsBIbpsAuthpayProtoinfoService usBIbpsAuthpayProtoinfoService;
    @Autowired
    private UsBMpsAcctselProtoinfoService usBMpsAcctselProtoinfoService;
    @Autowired
    private UsBMpsAuthpayProtoinfoService usBMpsAuthpayProtoinfoService;
    @Autowired
    private UsBMpsAgentpayProtoinfoService usBMpsAgentpayProtoinfoService;
    @Autowired
    private UsBCup2AuthpayProtoinfoService usBCup2AuthpayProtoinfoService;
    @Autowired
    private UsBCup2DebtransferProtoinfoService usBCup2DebtransferProtoinfoService;

    public YuinResultDto<Integer> tradeFlow(ProtoSignReqDto protoSignReqDto) {
        YuinResultDto resultDto = null;
        String sysid = protoSignReqDto.getSysid();
        String appid = protoSignReqDto.getAppid();
        String prototype = protoSignReqDto.getPrototype();
        Map<String, Object> protoinfomap = protoSignReqDto.getProtoinfo();
        String[] amtField = new String[]{"singleamtlmt", "cycdeamtlmt", "dayamtlmt", "monthamtlmt", "amt"};
        for (int i = 0; i < amtField.length; ++i) {
            if (!protoinfomap.containsKey(amtField[i])) continue;
            protoinfomap.put(amtField[i], new BigDecimal(String.valueOf(protoinfomap.get(amtField[i]))));
        }
        resultDto = SignValid.validPrototypeDefind((String)sysid, (String)appid, (String)prototype);
        if (!resultDto.isSuccess()) {
            return resultDto;
        }
        HashMap<String, Function<Object, Object>> functionHashMap = new HashMap<String, Function<Object, Object>>();
        functionHashMap.put(ProtoTypeEnum.UPPT0103.getPrototype(), protoinfo -> this.signCnapsAgentpayProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0201.getPrototype(), protoinfo -> this.signIbpsAcctselProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0202.getPrototype(), protoinfo -> this.signIbpsAuthpayProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0301.getPrototype(), protoinfo -> this.signMpsAcctselProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0302.getPrototype(), protoinfo -> this.signMpsAuthpayProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0303.getPrototype(), protoinfo -> this.signMpsAgentpayProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0502.getPrototype(), protoinfo -> this.signCUP2AuthpayProto((Map)protoinfo));
        functionHashMap.put(ProtoTypeEnum.UPPT0504.getPrototype(), protoinfo -> this.signCUP2DebtransferProto((Map)protoinfo));
        try {
            resultDto = (YuinResultDto)((Function)functionHashMap.get(prototype)).apply(protoinfomap);
        }
        catch (DuplicateKeyException exception) {
            if ("1".equals(protoSignReqDto.getRepetflag())) {
                HashMap<String, Function<Object, Object>> repetFunctionHashMap = new HashMap<String, Function<Object, Object>>();
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0103.getPrototype(), protoinfo -> this.repetSignCnapsAgentpayProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0201.getPrototype(), protoinfo -> this.repetSignIbpsAcctselProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0202.getPrototype(), protoinfo -> this.repetSignIbpsAuthpayProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0301.getPrototype(), protoinfo -> this.repetSignMpsAcctselProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0302.getPrototype(), protoinfo -> this.repetSignMpsAuthpayProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0303.getPrototype(), protoinfo -> this.repetSignMpsAgentpayProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0502.getPrototype(), protoinfo -> this.repetSignCUP2AuthpayProto((Map)protoinfo));
                repetFunctionHashMap.put(ProtoTypeEnum.UPPT0504.getPrototype(), protoinfo -> this.repetSignCUP2DebtransferProto((Map)protoinfo));
                try {
                    resultDto = (YuinResultDto)((Function)repetFunctionHashMap.get(prototype)).apply(protoinfomap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    YuinLogUtils.getInst((Object)this).info("\u534f\u8bae\u5176\u4ed6\u9519:{}", (Object)e.getMessage());
                    return YuinResultDto.failure((String)"E1899", (String)String.format("\u534f\u8bae\u5176\u4ed6\u9519[%s]", e.getMessage()));
                }
            }
            exception.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("\u5f53\u524d\u534f\u8bae\u5df2\u5b58\u5728");
            return YuinResultDto.failure((String)"E1805", (String)"\u534f\u8bae\u5df2\u5b58\u5728");
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("\u534f\u8bae\u5176\u4ed6\u9519:{}", (Object)e.getMessage());
            return YuinResultDto.failure((String)"E1899", (String)String.format("\u534f\u8bae\u5176\u4ed6\u9519[%s]", e.getMessage()));
        }
        return resultDto;
    }

    private YuinResultDto<Integer> signCnapsAgentpayProto(Map<String, Object> protoinfo) {
        return this.usBCnapsAgentpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signIbpsAcctselProto(Map<String, Object> protoinfo) {
        return this.usBIbpsAcctselProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signIbpsAuthpayProto(Map<String, Object> protoinfo) {
        return this.usBIbpsAuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signMpsAcctselProto(Map<String, Object> protoinfo) {
        return this.usBMpsAcctselProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signMpsAuthpayProto(Map<String, Object> protoinfo) {
        return this.usBMpsAuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signMpsAgentpayProto(Map<String, Object> protoinfo) {
        return this.usBMpsAgentpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signCUP2AuthpayProto(Map<String, Object> protoinfo) {
        return this.usBCup2AuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> signCUP2DebtransferProto(Map<String, Object> protoinfo) {
        return this.usBCup2DebtransferProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignCnapsAgentpayProto(Map<String, Object> protoinfo) {
        this.usBCnapsAgentpayProtoinfoService.delete(protoinfo);
        return this.usBCnapsAgentpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignIbpsAcctselProto(Map<String, Object> protoinfo) {
        this.usBIbpsAcctselProtoinfoService.delete(protoinfo);
        return this.usBIbpsAcctselProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignIbpsAuthpayProto(Map<String, Object> protoinfo) {
        this.usBIbpsAuthpayProtoinfoService.delete(protoinfo);
        return this.usBIbpsAuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignMpsAcctselProto(Map<String, Object> protoinfo) {
        this.usBMpsAcctselProtoinfoService.delete(protoinfo);
        return this.usBMpsAcctselProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignMpsAuthpayProto(Map<String, Object> protoinfo) {
        this.usBMpsAuthpayProtoinfoService.delete(protoinfo);
        return this.usBMpsAuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignMpsAgentpayProto(Map<String, Object> protoinfo) {
        this.usBMpsAgentpayProtoinfoService.delete(protoinfo);
        return this.usBMpsAgentpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignCUP2AuthpayProto(Map<String, Object> protoinfo) {
        this.usBCup2AuthpayProtoinfoService.delete(protoinfo);
        return this.usBCup2AuthpayProtoinfoService.save(protoinfo);
    }

    private YuinResultDto<Integer> repetSignCUP2DebtransferProto(Map<String, Object> protoinfo) {
        this.usBCup2AuthpayProtoinfoService.delete(protoinfo);
        return this.usBCup2DebtransferProtoinfoService.save(protoinfo);
    }
}

