/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.bsp.BspFeignServer;
import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.req.IcspSysHead;
import cn.com.yusys.yusp.common.req.IcspTradeHead;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.client.AdminSmUserClientService;
import cn.com.yusys.yusp.system.dao.SealCardInfoDao;
import cn.com.yusys.yusp.system.dao.SealCardTranDao;
import cn.com.yusys.yusp.system.domain.bo.SealCardInfoBo;
import cn.com.yusys.yusp.system.domain.bo.SealCardTranBo;
import cn.com.yusys.yusp.system.domain.entity.SealCardInfoEntity;
import cn.com.yusys.yusp.system.domain.entity.SealCardTranEntity;
import cn.com.yusys.yusp.system.service.SealCardTranService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SealCardTranServiceImpl
implements SealCardTranService {
    private static final Logger log = LoggerFactory.getLogger(SealCardTranServiceImpl.class);
    @Autowired
    SealCardInfoDao sealCardInfoDao;
    @Autowired
    SealCardTranDao sealCardTranDao;
    @Autowired
    private AdminSmUserClientService adminSmUserClientService;
    @Autowired
    BspFeignServer bspFeignServer;

    @Override
    public IcspResultDto<SealCardInfoEntity> insert(IcspRequest<SealCardInfoEntity> request) {
        SealCardInfoEntity body = (SealCardInfoEntity)request.getBody();
        body.setPreUserId(body.getUserId());
        body.setVoucherStatus("ACT");
        body.setCreateDate(DateUtils.formatDate((String)"yyyyMMdd"));
        int insert = this.sealCardInfoDao.insert(body);
        if (insert < 1) {
            return IcspResultDto.failure((String)"500", (String)"\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
        return IcspResultDto.success((Object)body);
    }

    @Override
    @Transactional
    public IcspResultDto<SealCardInfoEntity> update(IcspRequest<SealCardInfoBo> request) {
        SealCardInfoBo body = (SealCardInfoBo)request.getBody();
        String voucherNo = body.getVoucherNo();
        String newVoucherNo = body.getNewVoucherNo();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SealCardInfoEntity::getVoucherNo, (Object)voucherNo);
        SealCardInfoEntity sealCardInfoEntity = new SealCardInfoEntity();
        sealCardInfoEntity.setVoucherStatus("CAN");
        this.sealCardInfoDao.update(sealCardInfoEntity, (Wrapper)wrapper);
        try {
            BeanUtils.copyProperties((Object)sealCardInfoEntity, (Object)body);
        }
        catch (Exception E) {
            return IcspResultDto.failure((String)"500", (String)"\u64cd\u4f5c\u5931\u8d25");
        }
        sealCardInfoEntity.setVoucherNo(newVoucherNo);
        sealCardInfoEntity.setVoucherStatus("ACT");
        sealCardInfoEntity.setPreUserId(sealCardInfoEntity.getUserId());
        sealCardInfoEntity.setCreateDate(DateUtils.formatDate((String)"yyyyMMdd"));
        this.sealCardInfoDao.insert(sealCardInfoEntity);
        return IcspResultDto.success((Object)sealCardInfoEntity);
    }

    @Override
    public IcspResultDto<SealCardInfoEntity> delete(IcspRequest<SealCardInfoEntity> request) {
        SealCardInfoEntity body = (SealCardInfoEntity)request.getBody();
        body.setVoucherStatus("DES");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SealCardInfoEntity::getVoucherNo, (Object)body.getVoucherNo());
        this.sealCardInfoDao.update(body, (Wrapper)wrapper);
        return IcspResultDto.success((Object)body);
    }

    @Override
    public IcspResultDto<SealCardInfoEntity> queryInfo(IcspRequest<SealCardInfoEntity> request) {
        SealCardInfoEntity entity = (SealCardInfoEntity)request.getBody();
        IcspTradeHead tradeHead = request.getTradeHead();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(!StringUtils.isEmpty((CharSequence)entity.getVoucherNo()), SealCardInfoEntity::getVoucherNo, (Object)entity.getVoucherNo());
        lambdaQueryWrapper.eq(!StringUtils.isEmpty((CharSequence)entity.getUserId()), SealCardInfoEntity::getUserId, (Object)entity.getUserId());
        SealCardInfoEntity sealCardInfoEntity = (SealCardInfoEntity)this.sealCardInfoDao.selectOne((Wrapper)lambdaQueryWrapper);
        if (sealCardInfoEntity == null) {
            return IcspResultDto.failure((String)"500", (String)"\u672a\u83b7\u53d6\u5230\u6570\u636e");
        }
        return IcspResultDto.success((Object)sealCardInfoEntity);
    }

    @Override
    @Transactional
    public IcspResultDto<SealCardTranEntity> insertCardTran(List<SealCardTranEntity> list) throws Exception {
        String serno = this.generatePkNo();
        for (SealCardTranEntity entity : list) {
            String recever = entity.getRecever();
            String transfer = entity.getTransfer();
            String voucherNo = entity.getVoucherNo();
            String tranType = entity.getTranType();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SealCardInfoEntity::getVoucherNo, (Object)voucherNo);
            SealCardInfoEntity sealCardInfoEntity = (SealCardInfoEntity)this.sealCardInfoDao.selectOne((Wrapper)wrapper);
            if (!"ACT".equals(sealCardInfoEntity.getVoucherStatus())) {
                return IcspResultDto.failure((String)"500", (String)"\u51ed\u8bc1\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u4ea4\u63a5");
            }
            if (!"05".equals(tranType)) continue;
            if (sealCardInfoEntity != null) {
                if (sealCardInfoEntity.getUserId().equals(transfer)) continue;
                return IcspResultDto.failure((String)"500", (String)"\u51ed\u8bc1\u4fdd\u7ba1\u4eba\u4e0e\u4ea4\u63a5\u4eba\u4e0d\u540c");
            }
            return IcspResultDto.failure((String)"500", (String)"\u7cfb\u7edf\u9519\u8bef");
        }
        log.info("list_siez-" + list.size());
        for (SealCardTranEntity entity : list) {
            int insert = this.sealCardTranDao.insert(entity);
            if (insert >= 1) continue;
            return IcspResultDto.failure((String)"500", (String)"\u6570\u636e\u63d2\u5165\u5931\u8d25");
        }
        for (SealCardTranEntity sealCardTranEntity : list) {
        }
        return IcspResultDto.success(null);
    }

    @Override
    public IcspResultDto<List<SealCardTranEntity>> queryHistory(IcspRequest<SealCardTranBo> request) {
        SealCardTranBo body = (SealCardTranBo)request.getBody();
        IcspSysHead sysHead = request.getSysHead();
        PageHelper.startPage((int)sysHead.getPageNum(), (int)sysHead.getPageSize());
        List<SealCardTranEntity> sealCardTranEntities = this.sealCardTranDao.selectByList(body);
        PageHelper.clearPage();
        return IcspResultDto.success(sealCardTranEntities);
    }

    @Override
    public IcspResultDto queryCardCount(SealCardInfoEntity sealCardInfoEntity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SealCardInfoEntity::getVoucherStatus, (Object)"ACT");
        wrapper.eq(SealCardInfoEntity::getOrgId, (Object)sealCardInfoEntity.getOrgId());
        Integer integer = this.sealCardInfoDao.selectCount((Wrapper)wrapper);
        return IcspResultDto.success((Object)integer);
    }

    private String generatePkNo() {
        return "E" + DateUtils.formatDate((String)DateUtils.PATTERN_DATETIME_COMPACT_SSS) + StringUtils.getUUID().substring(0, 7);
    }
}

