/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamUsgProductBo;
import cn.com.yusys.yusp.param.vo.ParamUsgProductVo;
import cn.com.yusys.yusp.param.vo.ParamUsgTransVo;
import cn.com.yusys.yusp.sequence.client.SequenceTemplateService;
import cn.com.yusys.yusp.system.dao.ParamUsgProductDao;
import cn.com.yusys.yusp.system.dao.ParamUsgTransDao;
import cn.com.yusys.yusp.system.dao.ProductTypeMappingDao;
import cn.com.yusys.yusp.system.domain.entity.ParamUsgProductEntity;
import cn.com.yusys.yusp.system.domain.entity.ParamUsgTransEntity;
import cn.com.yusys.yusp.system.domain.entity.ProductTypeMappingEntity;
import cn.com.yusys.yusp.system.domain.query.ParamUsgProductQuery;
import cn.com.yusys.yusp.system.domain.query.ParamUsgTransQuery;
import cn.com.yusys.yusp.system.service.ParamUsgProductService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamUsgProductServiceImpl
implements ParamUsgProductService {
    @Autowired
    private ParamUsgProductDao paramUsgProductDao;
    @Autowired
    private ProductTypeMappingDao productTypeMappingDao;
    @Autowired
    private SequenceTemplateService sequenceTemplateService;
    @Autowired
    private ParamUsgTransDao paramUsgTransDao;

    @Override
    public int create(ParamUsgProductBo paramUsgProductBo) throws Exception {
        QueryModel model = new QueryModel();
        ParamUsgProductQuery queryParam = new ParamUsgProductQuery();
        queryParam.setProductName(paramUsgProductBo.getProductName());
        model.setCondition((Object)queryParam);
        List<ParamUsgProductVo> list = this.list(model);
        if (null != list && list.size() > 0) {
            throw new IcspException("500", "\u4ea7\u54c1\uff1a" + paramUsgProductBo.getProductName() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\uff01");
        }
        int result = 0;
        String productId = null;
        try {
            productId = this.sequenceTemplateService.getSequenceTemplate("PRODUCT_ID", null);
        }
        catch (Exception e) {
            throw new IcspException("500", "\u4ea7\u54c1\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff01");
        }
        paramUsgProductBo.setProductId(productId);
        ParamUsgProductEntity paramUsgProductEntity = new ParamUsgProductEntity();
        BeanUtils.beanCopy((Object)paramUsgProductBo, (Object)paramUsgProductEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgProductEntity.setCreateDate(currentDate);
        paramUsgProductEntity.setCreateTime(currentTime);
        paramUsgProductEntity.setCreateTellerNo(userId);
        paramUsgProductEntity.setUpdateDate(currentDate);
        paramUsgProductEntity.setUpdateTime(currentTime);
        paramUsgProductEntity.setUpdateTellerNo(userId);
        result = this.paramUsgProductDao.insert(paramUsgProductEntity);
        if (null != paramUsgProductBo.getTypeNos() && !paramUsgProductBo.getTypeNos().isEmpty()) {
            ArrayList<ProductTypeMappingEntity> typeList = new ArrayList<ProductTypeMappingEntity>();
            ProductTypeMappingEntity productTypeMappingEntity = null;
            for (String typeNo : paramUsgProductBo.getTypeNos()) {
                productTypeMappingEntity = new ProductTypeMappingEntity();
                productTypeMappingEntity.setProductId(productId);
                productTypeMappingEntity.setTypeNo(typeNo);
                typeList.add(productTypeMappingEntity);
            }
            this.productTypeMappingDao.batchInsert(typeList);
        }
        return result;
    }

    @Override
    public ParamUsgProductVo show(ParamUsgProductQuery paramUsgProductQuery) throws Exception {
        if (StringUtils.isEmpty((CharSequence)paramUsgProductQuery.getProductId())) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramUsgProductQuery);
        List<ParamUsgProductVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ productId=" + paramUsgProductQuery.getProductId() + " ]");
        }
        return list.get(0);
    }

    @Override
    public List<ParamUsgProductVo> index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamUsgProductVo> list = this.paramUsgProductDao.selectVoByModel(model);
        for (ParamUsgProductVo entity : list) {
            List<String> typeNos = this.productTypeMappingDao.selectByProductId(entity.getProductId());
            entity.setTypeNos(typeNos);
        }
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamUsgProductVo> list(QueryModel model) throws Exception {
        List<ParamUsgProductEntity> list = this.paramUsgProductDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamUsgProductVo.class);
        for (ParamUsgProductVo entity : listVo) {
            List<String> typeNos = this.productTypeMappingDao.selectByProductId(entity.getProductId());
            entity.setTypeNos(typeNos);
        }
        return listVo;
    }

    @Override
    public int update(ParamUsgProductBo paramUsgProductBo) throws Exception {
        int result = 0;
        ParamUsgProductEntity paramUsgProductEntity = new ParamUsgProductEntity();
        BeanUtils.beanCopy((Object)paramUsgProductBo, (Object)paramUsgProductEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgProductEntity.setUpdateDate(currentDate);
        paramUsgProductEntity.setUpdateTime(currentTime);
        paramUsgProductEntity.setUpdateTellerNo(userId);
        result = this.paramUsgProductDao.updateByPrimaryKey(paramUsgProductEntity);
        if (!paramUsgProductBo.getTypeNos().isEmpty()) {
            this.productTypeMappingDao.deleteByPrimaryKey(paramUsgProductBo.getProductId());
            ArrayList<ProductTypeMappingEntity> typeList = new ArrayList<ProductTypeMappingEntity>();
            ProductTypeMappingEntity productTypeMappingEntity = null;
            for (String typeNo : paramUsgProductBo.getTypeNos()) {
                productTypeMappingEntity = new ProductTypeMappingEntity();
                productTypeMappingEntity.setProductId(paramUsgProductBo.getProductId());
                productTypeMappingEntity.setTypeNo(typeNo);
                typeList.add(productTypeMappingEntity);
            }
            this.productTypeMappingDao.batchInsert(typeList);
        }
        return result;
    }

    @Override
    public int delete(String productId) throws Exception {
        return this.paramUsgProductDao.deleteByPrimaryKey(productId);
    }

    @Override
    public List<ParamUsgProductVo> queryProductByType(ParamUsgProductQuery paramUsgProductQuery) throws Exception {
        String productType = paramUsgProductQuery.getProductType();
        if (StringUtils.isEmpty((CharSequence)productType)) {
            throw new IcspException("500", "\u8bf7\u4e0a\u4f20\u5f53\u524d\u5ba2\u6237\u7c7b\u578b");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramUsgProductQuery);
        model.setSort(" dispOrder");
        List<ParamUsgProductEntity> list = this.paramUsgProductDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamUsgProductVo.class);
        for (ParamUsgProductVo vo : listVo) {
            QueryModel transModel = new QueryModel();
            ParamUsgTransQuery paramTrans = new ParamUsgTransQuery();
            paramTrans.setProductId(vo.getProductId());
            transModel.setCondition((Object)paramTrans);
            List<ParamUsgTransEntity> transEntities = this.paramUsgTransDao.selectByModel(transModel);
            List transVos = (List)BeanUtils.beansCopy(transEntities, ParamUsgTransVo.class);
            vo.setUsgTrans(transVos);
        }
        return listVo;
    }
}

