/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.client.AdminSmUserClientService;
import cn.com.yusys.yusp.param.bo.ParamTradeBo;
import cn.com.yusys.yusp.param.vo.ParamTradeVo;
import cn.com.yusys.yusp.system.dao.ParamTradeDao;
import cn.com.yusys.yusp.system.domain.entity.ParamTradeEntity;
import cn.com.yusys.yusp.system.domain.query.ParamTradeQuery;
import cn.com.yusys.yusp.system.service.ParamTradeService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamTradeServiceImpl
implements ParamTradeService {
    @Autowired
    private ParamTradeDao paramTradeMapper;
    @Autowired
    private AdminSmUserClientService adminSmUserClientService;

    @Override
    public int create(ParamTradeBo paramTradeBo) throws Exception {
        ParamTradeEntity paramTradeEntity = new ParamTradeEntity();
        BeanUtils.beanCopy((Object)paramTradeBo, (Object)paramTradeEntity);
        paramTradeEntity.setLastChgUser(SessionUtils.getUserId());
        paramTradeEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.paramTradeMapper.insert(paramTradeEntity);
    }

    @Override
    public ParamTradeVo show(ParamTradeQuery paramTradeQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramTradeQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + paramTradeQuery.getTradeId() + " ]");
        }
        return (ParamTradeVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamTradeVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamTradeEntity> list = this.paramTradeMapper.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamTradeVo> list(QueryModel model) throws Exception {
        List<ParamTradeEntity> list = this.paramTradeMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, ParamTradeVo.class);
        return voList;
    }

    @Override
    public int update(ParamTradeBo paramTradeBo) throws Exception {
        ParamTradeEntity paramTradeEntity = new ParamTradeEntity();
        BeanUtils.beanCopy((Object)paramTradeBo, (Object)paramTradeEntity);
        paramTradeEntity.setLastChgUser(SessionUtils.getUserId());
        paramTradeEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.paramTradeMapper.updateByPrimaryKey(paramTradeEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.paramTradeMapper.deleteByPrimaryKey(tradeId);
    }

    @Override
    public ParamTradeVo showAndSign(IcspRequest<ParamTradeQuery> request) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition(request.getBody());
        List<ParamTradeVo> list = this.list(model);
        ParamTradeVo paramTradeVo = new ParamTradeVo();
        if (list == null || list.size() == 0) {
            paramTradeVo.setIsChkSign("1");
        } else {
            paramTradeVo = list.get(0);
        }
        paramTradeVo.setSignSts("2");
        String workDate = request.getTradeHead().getWorkDate();
        return paramTradeVo;
    }
}

