/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.param.dto.TradeConfigReq;
import cn.com.yusys.yusp.param.dto.TradeConfigResp;
import cn.com.yusys.yusp.param.vo.ParamPlsOrgTradeVo;
import cn.com.yusys.yusp.param.vo.ParamPlsOrgVo;
import cn.com.yusys.yusp.param.vo.ParamPlsSealVo;
import cn.com.yusys.yusp.param.vo.ParamPlsTradeVo;
import cn.com.yusys.yusp.param.vo.ParamTradeVo;
import cn.com.yusys.yusp.system.domain.query.ParamPlsOrgQuery;
import cn.com.yusys.yusp.system.domain.query.ParamPlsOrgTradeQuery;
import cn.com.yusys.yusp.system.domain.query.ParamPlsSealQuery;
import cn.com.yusys.yusp.system.domain.query.ParamPlsTradeQuery;
import cn.com.yusys.yusp.system.domain.query.ParamTradeQuery;
import cn.com.yusys.yusp.system.service.ParamPlsOrgService;
import cn.com.yusys.yusp.system.service.ParamPlsOrgTradeService;
import cn.com.yusys.yusp.system.service.ParamPlsSealService;
import cn.com.yusys.yusp.system.service.ParamPlsTradeService;
import cn.com.yusys.yusp.system.service.ParamService;
import cn.com.yusys.yusp.system.service.ParamTradeService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamServiceImpl
implements ParamService {
    private static final Logger logger = LoggerFactory.getLogger(ParamServiceImpl.class);
    @Autowired
    private ParamTradeService paramTradeService;
    @Autowired
    private ParamPlsOrgService paramPlsOrgService;
    @Autowired
    private ParamPlsSealService paramPlsSealService;
    @Autowired
    private ParamPlsTradeService paramPlsTradeService;
    @Autowired
    private ParamPlsOrgTradeService paramPlsOrgTradeService;

    @Override
    public TradeConfigResp queryTradeParamConfig(TradeConfigReq tradeConfigReq) throws Exception {
        TradeConfigResp resp = new TradeConfigResp();
        if (StringUtils.isEmpty((CharSequence)tradeConfigReq.getMenuId())) {
            return resp;
        }
        ParamTradeQuery query = new ParamTradeQuery();
        query.setTradeId(tradeConfigReq.getMenuId());
        QueryModel queryModel = new QueryModel();
        queryModel.setCondition((Object)query);
        List<ParamTradeVo> list = this.paramTradeService.list(queryModel);
        if (list != null && !list.isEmpty()) {
            BeanUtils.beanCopy((Object)list.get(0), (Object)resp);
            resp.setAcctReadOnly(list.get(0).getIsWriteMagnetic());
        }
        ParamPlsSealQuery sealQuery = new ParamPlsSealQuery();
        sealQuery.setTradeCode(tradeConfigReq.getMenuId());
        queryModel = new QueryModel();
        queryModel.setCondition((Object)sealQuery);
        List<ParamPlsSealVo> list1 = this.paramPlsSealService.list(queryModel);
        if (list1 != null && !list1.isEmpty()) {
            resp.setSealFlag(list1.get(0).getTradeType());
        }
        try {
            resp.setPlsType("N");
            resp.setTradeMode("2");
            ParamPlsOrgQuery orgQuery = new ParamPlsOrgQuery();
            orgQuery.setOrgId(tradeConfigReq.getOrgId());
            queryModel = new QueryModel();
            queryModel.setCondition((Object)orgQuery);
            List<ParamPlsOrgVo> list2 = this.paramPlsOrgService.list(queryModel);
            if (list2 == null || list2.isEmpty() || "1".equals(list2.get(0).getTradeType())) {
                resp.setPlsType("N");
                resp.setTradeMode("2");
                return resp;
            }
            ParamPlsTradeQuery tradeQuery = new ParamPlsTradeQuery();
            tradeQuery.setTradeCode(tradeConfigReq.getMenuId());
            queryModel = new QueryModel();
            queryModel.setCondition((Object)tradeQuery);
            List<ParamPlsTradeVo> list3 = this.paramPlsTradeService.list(queryModel);
            if (list3 == null || list3.isEmpty() || "2".equals(list3.get(0).getTradeType())) {
                resp.setPlsType("N");
                resp.setTradeMode("2");
                return resp;
            }
            String orgFlag = list3.get(0).getOrgFlag();
            if ("0".equals(orgFlag)) {
                resp.setPlsType("Y");
                resp.setTradeMode("1");
                resp.setConfirmFlag(list3.get(0).getConfirmFlag());
                resp.setReceiptFlag(list3.get(0).getReceiptFlag());
                resp.setSignNameFlag(list3.get(0).getSignNameFlag());
                return resp;
            }
            ParamPlsOrgTradeQuery orgTradeQuery = new ParamPlsOrgTradeQuery();
            orgTradeQuery.setOrgCode(tradeConfigReq.getOrgId());
            orgTradeQuery.setTradeCode(tradeConfigReq.getMenuId());
            queryModel = new QueryModel();
            queryModel.setCondition((Object)tradeQuery);
            List<ParamPlsOrgTradeVo> list4 = this.paramPlsOrgTradeService.list(queryModel);
            if (list4 == null || list4.isEmpty() || "1".equals(list4.get(0).getTradeType())) {
                resp.setPlsType("N");
                resp.setTradeMode("2");
                return resp;
            }
            resp.setPlsType("Y");
            resp.setTradeMode("1");
            resp.setConfirmFlag(list4.get(0).getConfirmFlag());
            resp.setReceiptFlag(list4.get(0).getReceiptFlag());
            resp.setSignNameFlag(list4.get(0).getSignNameFlag());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return resp;
    }
}

