/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.dto.MidReqLocalHead;
import cn.com.yusys.yusp.operation.service.impl.BspFeignServerImpl;
import cn.com.yusys.yusp.param.bo.ParamPlsSealBo;
import cn.com.yusys.yusp.param.bo.T11002000063_01_ReqBody;
import cn.com.yusys.yusp.param.vo.ParamPlsSealVo;
import cn.com.yusys.yusp.param.vo.T11002000063_01_BspResp;
import cn.com.yusys.yusp.param.vo.T11002000063_01_RespBody;
import cn.com.yusys.yusp.system.dao.ParamPlsSealDao;
import cn.com.yusys.yusp.system.domain.entity.ParamPlsSealEntity;
import cn.com.yusys.yusp.system.domain.query.ParamPlsSealQuery;
import cn.com.yusys.yusp.system.service.ParamPlsSealService;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamPlsSealServiceImpl
implements ParamPlsSealService {
    @Autowired
    private ParamPlsSealDao paramPlsSealDao;
    @Autowired
    BspFeignServerImpl bspFeignServer;
    MidReqLocalHead midReqLocalHead = new MidReqLocalHead();

    @Override
    public int create(IcspRequest<ParamPlsSealBo> request) throws Exception {
        ParamPlsSealBo paramPlsSealBo = (ParamPlsSealBo)request.getBody();
        paramPlsSealBo.setLastChgDt(request.getTradeHead().getWorkDate());
        paramPlsSealBo.setLastChgUser(request.getTradeHead().getUserId());
        ParamPlsSealEntity paramPlsSealEntity = new ParamPlsSealEntity();
        BeanUtils.beanCopy((Object)paramPlsSealBo, (Object)paramPlsSealEntity);
        return this.paramPlsSealDao.insert(paramPlsSealEntity);
    }

    @Override
    public ParamPlsSealVo show(ParamPlsSealQuery paramPlsSealQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramPlsSealQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeCode=" + paramPlsSealQuery.getTradeCode() + " ]");
        }
        return (ParamPlsSealVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamPlsSealVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamPlsSealEntity> list = this.paramPlsSealDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamPlsSealVo> list(QueryModel model) throws Exception {
        List<ParamPlsSealEntity> list = this.paramPlsSealDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamPlsSealVo.class);
        return listVo;
    }

    @Override
    public int update(IcspRequest<ParamPlsSealBo> request) throws Exception {
        ParamPlsSealBo paramPlsSealBo = (ParamPlsSealBo)request.getBody();
        paramPlsSealBo.setLastChgDt(request.getTradeHead().getWorkDate());
        paramPlsSealBo.setLastChgUser(request.getTradeHead().getUserId());
        ParamPlsSealEntity paramPlsSealEntity = new ParamPlsSealEntity();
        BeanUtils.beanCopy((Object)paramPlsSealBo, (Object)paramPlsSealEntity);
        return this.paramPlsSealDao.updateByPrimaryKey(paramPlsSealEntity);
    }

    @Override
    public int delete(String tradeCode) throws Exception {
        return this.paramPlsSealDao.deleteByPrimaryKey(tradeCode);
    }

    @Override
    public void save(IcspRequest<ParamPlsSealQuery> request, HttpServletResponse response) throws Exception {
        ParamPlsSealQuery query = (ParamPlsSealQuery)request.getBody();
        QueryModel model = new QueryModel();
        model.setPage(request.getQueryModel().getPage());
        model.setSize(request.getQueryModel().getSize());
        model.setCondition((Object)query);
        List<ParamPlsSealEntity> paramPlsSealEntities = this.paramPlsSealDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cTradeCodeTitle = rowTitle.createCell(0);
        cTradeCodeTitle.setCellValue("\u4ea4\u6613\u7801");
        Cell cTradeTypeTitle = rowTitle.createCell(1);
        cTradeTypeTitle.setCellValue("\u4ea4\u6613\u7c7b\u578b");
        Cell cLastChgDtTitle = rowTitle.createCell(2);
        cLastChgDtTitle.setCellValue("\u66f4\u65b0\u65e5\u671f");
        Cell cLastChgUserTitle = rowTitle.createCell(3);
        cLastChgUserTitle.setCellValue("\u66f4\u65b0\u4eba");
        int num = 1;
        for (ParamPlsSealEntity paramPlsSealEntity : paramPlsSealEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cTradeCode = row.createCell(0);
            cTradeCode.setCellValue(paramPlsSealEntity.getTradeCode());
            Cell cTradeType = row.createCell(1);
            cTradeType.setCellValue(paramPlsSealEntity.getTradeType());
            Cell cLastChgDt = row.createCell(2);
            cLastChgDt.setCellValue(paramPlsSealEntity.getLastChgDt());
            Cell cLastChgUser = row.createCell(3);
            cLastChgUser.setCellValue(paramPlsSealEntity.getLastChgUser());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            wk.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            String date = DateUtils.formatDateTimeByDef();
            date = date.replace(" ", "").replace(":", "").replace("-", "");
            String fileName = "\u65e0\u7eb8\u5316\u7535\u5b50\u7ae0\u914d\u7f6e\u8868.xls";
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.reset();
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.addHeader("Content-Length", "" + bytes.length);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
        }
    }

    @Override
    public T11002000063_01_RespBody getT11002000063_01(IcspRequest<T11002000063_01_ReqBody> request) throws Exception {
        T11002000063_01_ReqBody t11002000063_01_reqBody = (T11002000063_01_ReqBody)request.getBody();
        t11002000063_01_reqBody.setORIG_TELLER_SEQ_NO(request.getTradeHead().getTellerSerialNo());
        t11002000063_01_reqBody.setOLD_TRAN_CODE(request.getTradeHead().getTradeCode());
        t11002000063_01_reqBody.setORI_CORE_SEQ_NO(request.getTradeHead().getGlobalSeq());
        BspReq bspReq2 = new BspReq();
        ReqSysHead sys_head = new ReqSysHead();
        BeanUtils.beanCopy((Object)request.getSysHead(), (Object)sys_head);
        sys_head.setSERVICE_CODE("11002000063");
        sys_head.setSERVICE_SCENE("01");
        sys_head.setAUTH_FLAG("N");
        sys_head.setUSER_ID(request.getTradeHead().getUserId());
        sys_head.setBRANCH_ID(request.getTradeHead().getOrgId());
        bspReq2.setSYS_HEAD(sys_head);
        bspReq2.setLOCAL_HEAD((Object)this.midReqLocalHead);
        bspReq2.setBODY((Object)t11002000063_01_reqBody);
        T11002000063_01_BspResp t11002000063_01_bspResp = (T11002000063_01_BspResp)this.bspFeignServer.call(bspReq2, T11002000063_01_BspResp.class);
        T11002000063_01_RespBody t11002000063_01_respBody = t11002000063_01_bspResp.getBODY();
        return t11002000063_01_respBody;
    }
}

