/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamPlsOrgBo;
import cn.com.yusys.yusp.param.vo.ParamPlsOrgVo;
import cn.com.yusys.yusp.system.dao.ParamPlsOrgDao;
import cn.com.yusys.yusp.system.domain.entity.ParamPlsOrgEntity;
import cn.com.yusys.yusp.system.domain.query.ParamPlsOrgQuery;
import cn.com.yusys.yusp.system.service.ParamPlsOrgService;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamPlsOrgServiceImpl
implements ParamPlsOrgService {
    @Autowired
    private ParamPlsOrgDao paramPlsOrgDao;

    @Override
    public int create(ParamPlsOrgBo paramPlsOrgBo) throws Exception {
        ParamPlsOrgEntity paramPlsOrgEntity1 = new ParamPlsOrgEntity();
        paramPlsOrgEntity1.setOrgId(paramPlsOrgBo.getOrgId());
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramPlsOrgEntity1);
        List<ParamPlsOrgEntity> paramPlsOrgEntityList = this.paramPlsOrgDao.selectByModel(model);
        if (paramPlsOrgEntityList != null && paramPlsOrgEntityList.size() > 0) {
            throw new IcspException("500", "\u8be5\u673a\u6784\u5df2\u914d\u7f6e[" + paramPlsOrgBo.getOrgId() + " ]");
        }
        ParamPlsOrgEntity paramPlsOrgEntity = new ParamPlsOrgEntity();
        BeanUtils.beanCopy((Object)paramPlsOrgBo, (Object)paramPlsOrgEntity);
        paramPlsOrgEntity.setLastChgUser(SessionUtils.getUserId());
        paramPlsOrgEntity.setLastChgDate(DateUtils.formatDateByDef());
        return this.paramPlsOrgDao.insert(paramPlsOrgEntity);
    }

    @Override
    public ParamPlsOrgVo show(IcspRequest<ParamPlsOrgQuery> request) throws Exception {
        List list = this.index(request);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ]");
        }
        return (ParamPlsOrgVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamPlsOrgVo.class)
    public List index(IcspRequest<ParamPlsOrgQuery> request) throws Exception {
        ParamPlsOrgQuery query = (ParamPlsOrgQuery)request.getBody();
        QueryModel model = new QueryModel();
        model.setCondition((Object)query);
        PageHelper.startPage((int)request.getSysHead().getPageNum(), (int)request.getSysHead().getPageSize());
        List<ParamPlsOrgVo> list = this.paramPlsOrgDao.selectByOrgId(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamPlsOrgVo> list(QueryModel model) throws Exception {
        List<ParamPlsOrgEntity> list = this.paramPlsOrgDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamPlsOrgVo.class);
        return listVo;
    }

    @Override
    public int update(ParamPlsOrgBo paramPlsOrgBo) throws Exception {
        ParamPlsOrgEntity paramPlsOrgEntity = new ParamPlsOrgEntity();
        BeanUtils.beanCopy((Object)paramPlsOrgBo, (Object)paramPlsOrgEntity);
        paramPlsOrgEntity.setLastChgUser(SessionUtils.getUserId());
        paramPlsOrgEntity.setLastChgDate(DateUtils.formatDateByDef());
        return this.paramPlsOrgDao.updateByPrimaryKey(paramPlsOrgEntity);
    }

    @Override
    public int delete(ParamPlsOrgBo paramPlsOrgBo) throws Exception {
        return this.paramPlsOrgDao.deleteByPrimaryKey(paramPlsOrgBo.getOrgId());
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<ParamPlsOrgEntity> paramPlsOrgEntities = this.paramPlsOrgDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cOrgNameTitle = rowTitle.createCell(1);
        cOrgNameTitle.setCellValue("\u673a\u6784\u540d\u79f0");
        Cell cTradeTypeTitle = rowTitle.createCell(2);
        cTradeTypeTitle.setCellValue("\u4ea4\u6613\u7c7b\u578b");
        Cell cLastChgUserTitle = rowTitle.createCell(3);
        cLastChgUserTitle.setCellValue("\u6700\u540e\u4fee\u7528\u6237");
        Cell cLastChgDateTitle = rowTitle.createCell(4);
        cLastChgDateTitle.setCellValue("\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        int num = 1;
        for (ParamPlsOrgEntity paramPlsOrgEntity : paramPlsOrgEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(paramPlsOrgEntity.getOrgId());
            Cell cOrgName = row.createCell(1);
            cOrgName.setCellValue(paramPlsOrgEntity.getOrgName());
            Cell cTradeType = row.createCell(2);
            if ("0".equals(paramPlsOrgEntity.getTradeType())) {
                cTradeType.setCellValue("\u65e0\u7eb8\u5316");
            }
            if ("1".equals(paramPlsOrgEntity.getTradeType())) {
                cTradeType.setCellValue("\u975e\u65e0\u7eb8\u5316");
            }
            Cell cLastChgUser = row.createCell(3);
            cLastChgUser.setCellValue(paramPlsOrgEntity.getLastChgUser());
            Cell cLastChgDate = row.createCell(4);
            cLastChgDate.setCellValue(paramPlsOrgEntity.getLastChgDate());
        }
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"PlsOrg_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

