/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.client.AdminSmOrgClient;
import cn.com.yusys.yusp.param.bo.ParamOrgBussDateBo;
import cn.com.yusys.yusp.param.vo.ParamOrgBussDateVo;
import cn.com.yusys.yusp.system.dao.ParamInitBussDateDao;
import cn.com.yusys.yusp.system.dao.ParamOrgBussDateDao;
import cn.com.yusys.yusp.system.domain.entity.ParamInitBussDateEntity;
import cn.com.yusys.yusp.system.domain.entity.ParamOrgBussDateEntity;
import cn.com.yusys.yusp.system.domain.query.ParamOrgBussDateQuery;
import cn.com.yusys.yusp.system.service.ParamOrgBussDateService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamOrgBussDateServiceImpl
implements ParamOrgBussDateService {
    @Autowired
    private ParamOrgBussDateDao paramOrgBussDateDao;
    @Autowired
    private ParamInitBussDateDao paramInitBussDateDao;
    @Autowired
    private AdminSmOrgClient adminSmOrgClient;

    @Override
    public int create(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        ParamOrgBussDateEntity paramOrgBussDateEntity = new ParamOrgBussDateEntity();
        BeanUtils.beanCopy((Object)paramOrgBussDateBo, (Object)paramOrgBussDateEntity);
        return this.paramOrgBussDateDao.insert(paramOrgBussDateEntity);
    }

    @Override
    public ParamOrgBussDateVo show(ParamOrgBussDateQuery paramOrgBussDateQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramOrgBussDateQuery);
        List<ParamOrgBussDateVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ orgId=" + paramOrgBussDateQuery.getOrgId() + " bussDate=" + paramOrgBussDateQuery.getBussDate() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=ParamOrgBussDateVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamOrgBussDateEntity> list = this.paramOrgBussDateDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamOrgBussDateVo> list(QueryModel model) throws Exception {
        List<ParamOrgBussDateEntity> list = this.paramOrgBussDateDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamOrgBussDateVo.class);
        return listVo;
    }

    @Override
    public int update(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        ParamOrgBussDateEntity paramOrgBussDateEntity = new ParamOrgBussDateEntity();
        BeanUtils.beanCopy((Object)paramOrgBussDateBo, (Object)paramOrgBussDateEntity);
        return this.paramOrgBussDateDao.updateByPrimaryKey(paramOrgBussDateEntity);
    }

    @Override
    public int delete(String orgId, String bussDate) throws Exception {
        return this.paramOrgBussDateDao.deleteByPrimaryKey(orgId, bussDate);
    }

    @Override
    public List<ParamOrgBussDateVo> queryMonth(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)paramOrgBussDateBo.getBussDate()) || StringUtils.isEmpty((CharSequence)paramOrgBussDateBo.getOrgId())) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u673a\u6784\u548c\u6708\u4efd");
        }
        this.checkInitOrgBussDate(paramOrgBussDateBo.getBussDate().substring(0, 4), paramOrgBussDateBo.getOrgId());
        ParamOrgBussDateEntity paramEntity = new ParamOrgBussDateEntity();
        BeanUtils.beanCopy((Object)paramOrgBussDateBo, (Object)paramEntity);
        List<ParamOrgBussDateEntity> list = this.paramOrgBussDateDao.queryAllDateByOrgId(paramEntity);
        List listVo = (List)BeanUtils.beansCopy(list, ParamOrgBussDateVo.class);
        return listVo;
    }

    @Override
    public int batchSave(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        List bussDateList = paramOrgBussDateBo.getBussDateList();
        if (null == bussDateList || bussDateList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u65e5\u671f");
        }
        this.checkInitOrgBussDate(((String)bussDateList.get(0)).substring(0, 4), paramOrgBussDateBo.getOrgId());
        ParamOrgBussDateEntity initEntity = new ParamOrgBussDateEntity();
        initEntity.setDateType("2");
        List<String> holidayList = this.paramInitBussDateDao.queryAllHoliday(initEntity);
        if (null == holidayList || holidayList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u5148\u914d\u7f6e\u5168\u5e74\u8282\u5047\u65e5");
        }
        ArrayList<ParamOrgBussDateEntity> updateEntity = new ArrayList<ParamOrgBussDateEntity>();
        ParamOrgBussDateEntity entity = null;
        for (String bussDate : bussDateList) {
            Date bussDay;
            String weekDay;
            String isBuss = paramOrgBussDateBo.getIsBuss();
            String dateType = "1";
            if (holidayList.contains(bussDate)) {
                isBuss = "N";
                dateType = "2";
            }
            if ("\u661f\u671f\u516d".equals(weekDay = DateUtils.formatDate((Date)(bussDay = DateUtils.parseDate((String)bussDate, (String)"yyyyMMdd")), (String)"EEEE")) || "\u661f\u671f\u65e5".equals(weekDay)) {
                dateType = "3";
            }
            entity = new ParamOrgBussDateEntity();
            entity.setBussDate(bussDate);
            entity.setIsBuss(isBuss);
            entity.setDateSts("2");
            entity.setDateType(dateType);
            entity.setOrgId(paramOrgBussDateBo.getOrgId());
            entity.setLastChgUser(SessionUtils.getUserId());
            entity.setLastChgDt(DateUtils.formatDateByDef());
            updateEntity.add(entity);
        }
        if (updateEntity.size() > 0) {
            this.paramOrgBussDateDao.batchUpdate(updateEntity);
        }
        return 0;
    }

    @Override
    public int batchSaveOrg(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        List bussDateList = paramOrgBussDateBo.getBussDateList();
        List orgIdList = paramOrgBussDateBo.getOrgIdList();
        if (null == bussDateList || bussDateList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8425\u4e1a\u65e5\u671f");
        }
        if (null == orgIdList || orgIdList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u8425\u4e1a\u65e5\u671f\u7684\u673a\u6784");
        }
        ParamOrgBussDateEntity initEntity = new ParamOrgBussDateEntity();
        initEntity.setDateType("2");
        List<String> holidayList = this.paramInitBussDateDao.queryAllHoliday(initEntity);
        if (null == holidayList || holidayList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u5148\u914d\u7f6e\u5168\u5e74\u8282\u5047\u65e5");
        }
        ArrayList<ParamOrgBussDateEntity> updateEntity = new ArrayList<ParamOrgBussDateEntity>();
        ParamOrgBussDateEntity entity = null;
        for (String orgId : orgIdList) {
            this.checkInitOrgBussDate(((String)bussDateList.get(0)).substring(0, 4), orgId);
            for (String bussDate : bussDateList) {
                Date bussDay;
                String weekDay;
                String isBuss = paramOrgBussDateBo.getIsBuss();
                String dateType = "1";
                if (holidayList.contains(bussDate)) {
                    isBuss = "N";
                    dateType = "2";
                }
                if ("\u661f\u671f\u516d".equals(weekDay = DateUtils.formatDate((Date)(bussDay = DateUtils.parseDate((String)bussDate, (String)"yyyy-MM-dd")), (String)"EEEE")) || "\u661f\u671f\u65e5".equals(weekDay)) {
                    dateType = "3";
                }
                entity = new ParamOrgBussDateEntity();
                entity.setBussDate(bussDate);
                entity.setIsBuss(isBuss);
                entity.setDateSts("2");
                entity.setDateType(dateType);
                entity.setOrgId(orgId);
                entity.setLastChgUser(SessionUtils.getUserId());
                entity.setLastChgDt(DateUtils.formatDateByDef());
                updateEntity.add(entity);
            }
        }
        if (updateEntity.size() > 0) {
            this.paramOrgBussDateDao.batchUpdate(updateEntity);
        }
        return 0;
    }

    @Override
    public int batchSaveOrgDay(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        List boList = paramOrgBussDateBo.getBoList();
        List orgIdList = paramOrgBussDateBo.getOrgIdList();
        if (null == boList || boList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8425\u4e1a\u65e5\u671f");
        }
        if (null == orgIdList || orgIdList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u8425\u4e1a\u65e5\u671f\u7684\u673a\u6784");
        }
        ParamOrgBussDateEntity initEntity = new ParamOrgBussDateEntity();
        initEntity.setDateType("2");
        List<String> holidayList = this.paramInitBussDateDao.queryAllHoliday(initEntity);
        if (null == holidayList || holidayList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u5148\u914d\u7f6e\u5168\u5e74\u8282\u5047\u65e5");
        }
        ArrayList<ParamOrgBussDateEntity> updateEntity = new ArrayList<ParamOrgBussDateEntity>();
        ParamOrgBussDateEntity entity = null;
        for (String orgId : orgIdList) {
            this.checkInitOrgBussDate(((ParamOrgBussDateBo)boList.get(0)).getBussDate().substring(0, 4), orgId);
            for (ParamOrgBussDateBo bo : boList) {
                Date bussDay;
                String weekDay;
                String isBuss = paramOrgBussDateBo.getIsBuss();
                String dateType = "1";
                if (holidayList.contains(bo.getBussDate())) {
                    isBuss = "N";
                    dateType = "2";
                }
                if ("\u661f\u671f\u516d".equals(weekDay = DateUtils.formatDate((Date)(bussDay = DateUtils.parseDate((String)bo.getBussDate(), (String)"yyyyMMdd")), (String)"EEEE")) || "\u661f\u671f\u65e5".equals(weekDay)) {
                    dateType = "3";
                }
                entity = new ParamOrgBussDateEntity();
                entity.setBussDate(bo.getBussDate());
                entity.setIsBuss(isBuss);
                entity.setDateSts("2");
                entity.setDateType(dateType);
                entity.setOrgId(orgId);
                entity.setLastChgUser(SessionUtils.getUserId());
                entity.setLastChgDt(DateUtils.formatDateByDef());
                updateEntity.add(entity);
            }
        }
        if (updateEntity.size() > 0) {
            this.paramOrgBussDateDao.batchUpdate(updateEntity);
        }
        return 0;
    }

    @Override
    public int initByOrgId(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        this.checkInitBussDate(paramOrgBussDateBo.getBussDate().substring(0, 4));
        int result = 0;
        ParamOrgBussDateEntity paramOrgBussDateEntity = new ParamOrgBussDateEntity();
        BeanUtils.beanCopy((Object)paramOrgBussDateBo, (Object)paramOrgBussDateEntity);
        paramOrgBussDateEntity.setBussDate(paramOrgBussDateBo.getBussDate().substring(0, 4));
        this.paramOrgBussDateDao.deleteOrg(paramOrgBussDateEntity);
        paramOrgBussDateEntity.setLastChgUser(SessionUtils.getUserId());
        paramOrgBussDateEntity.setLastChgDt(DateUtils.formatDateByDef());
        result = this.paramOrgBussDateDao.initByOrgId(paramOrgBussDateEntity);
        return result;
    }

    @Override
    public int initAllOrg(ParamOrgBussDateBo paramOrgBussDateBo) throws Exception {
        return 0;
    }

    public void checkInitBussDate(String bussYear) {
        ParamInitBussDateEntity paramEntity = new ParamInitBussDateEntity();
        paramEntity.setBussDate(bussYear);
        List<ParamInitBussDateEntity> entities = this.paramInitBussDateDao.queryYear(paramEntity);
        if (null == entities || entities.size() < 365) {
            throw new IcspException("500", "\u8bf7\u751f\u6210" + bussYear + "\u5e74\u7684\u6240\u6709\u8425\u4e1a\u65e5\u671f!");
        }
    }

    public void checkInitOrgBussDate(String bussYear, String orgId) {
        ParamOrgBussDateEntity paramEntity = new ParamOrgBussDateEntity();
        paramEntity.setBussDate(bussYear);
        paramEntity.setOrgId(orgId);
        List<ParamOrgBussDateEntity> entities = this.paramOrgBussDateDao.queryAllDateByOrgId(paramEntity);
        if (null == entities || entities.size() < 365) {
            throw new IcspException("500", "\u8bf7\u521d\u59cb\u5316\u673a\u6784" + bussYear + "\u5e74\u7684\u6240\u6709\u8425\u4e1a\u65e5\u671f!");
        }
    }
}

