/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.param.bo.ParamOpsTocbankBo;
import cn.com.yusys.yusp.param.vo.ParamOpsTocbankVo;
import cn.com.yusys.yusp.system.dao.ParamOpsTocbankDao;
import cn.com.yusys.yusp.system.domain.entity.ParamOpsTocbankEntity;
import cn.com.yusys.yusp.system.domain.query.ParamOpsTocbankQuery;
import cn.com.yusys.yusp.system.service.ParamOpsTocbankService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamOpsTocbankServiceImpl
implements ParamOpsTocbankService {
    private static final Logger logger = LoggerFactory.getLogger(ParamOpsTocbankServiceImpl.class);
    @Autowired
    private ParamOpsTocbankDao paramOpsTocbankDao;

    @Override
    public int create(ParamOpsTocbankBo paramOpsTocbankBo) throws Exception {
        paramOpsTocbankBo.setTocId(StringUtils.getUUID());
        ParamOpsTocbankEntity paramOpsTocbankEntity = new ParamOpsTocbankEntity();
        BeanUtils.beanCopy((Object)paramOpsTocbankBo, (Object)paramOpsTocbankEntity);
        return this.paramOpsTocbankDao.insert(paramOpsTocbankEntity);
    }

    @Override
    public ParamOpsTocbankVo show(ParamOpsTocbankQuery paramOpsTocbankQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramOpsTocbankQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tocId=" + paramOpsTocbankQuery.getTocId() + " ]");
        }
        return (ParamOpsTocbankVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamOpsTocbankVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamOpsTocbankEntity> list = this.paramOpsTocbankDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamOpsTocbankVo> list(QueryModel model) throws Exception {
        List<ParamOpsTocbankEntity> list = this.paramOpsTocbankDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamOpsTocbankVo.class);
        return listVo;
    }

    @Override
    public int update(ParamOpsTocbankBo paramOpsTocbankBo) throws Exception {
        ParamOpsTocbankEntity paramOpsTocbankEntity = new ParamOpsTocbankEntity();
        BeanUtils.beanCopy((Object)paramOpsTocbankBo, (Object)paramOpsTocbankEntity);
        return this.paramOpsTocbankDao.updateByPrimaryKey(paramOpsTocbankEntity);
    }

    @Override
    public int delete(String tocId) throws Exception {
        return this.paramOpsTocbankDao.deleteByPrimaryKey(tocId);
    }

    @Override
    public String queryToc(ParamOpsTocbankBo paramOpsTocbankBo) throws Exception {
        QueryModel model = new QueryModel();
        ParamOpsTocbankEntity paramOpsTocbankEntity = new ParamOpsTocbankEntity();
        paramOpsTocbankEntity.setMenuId(paramOpsTocbankBo.getMenuId());
        paramOpsTocbankEntity.setStsFlag("Y");
        model.setCondition((Object)paramOpsTocbankEntity);
        List<ParamOpsTocbankEntity> list = this.paramOpsTocbankDao.selectByModel(model);
        if (list.size() < 1) {
            logger.warn("\u8be5\u83dc\u5355\u672a\u914d\u7f6e" + paramOpsTocbankBo.getMenuId());
            return "";
        }
        String result = this.valueToString(list.get(0).getBigContent(), list.get(0).getBigContextName(), paramOpsTocbankBo.getDataMap());
        return Base64.encodeBase64String((byte[])result.getBytes());
    }

    private String valueToString(String bigContent, String bigContextName, Map<String, Object> dataMap) {
        String[] names = bigContextName.split(",");
        String newBigContent = bigContent.replaceAll("\\$\\{", "");
        int numA = (bigContent.length() - newBigContent.length()) / 2;
        if (numA > 0) {
            int numB = 0;
            if (StringUtils.nonEmpty((CharSequence)bigContextName)) {
                numB = names.length;
            }
            for (int n = 1; n <= numA; ++n) {
                Object value;
                bigContent = n > numB ? bigContent.replace("${" + n + "}", "") : ((value = dataMap.get(names[n - 1])) != null && value instanceof String ? bigContent.replace("${" + n + "}", value.toString()) : (value != null && value instanceof Number ? bigContent.replace("${" + n + "}", value.toString()) : bigContent.replace("${" + n + "}", "")));
            }
        }
        return bigContent;
    }
}

