/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.util.IcspSessionUtils;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamMarketingBo;
import cn.com.yusys.yusp.param.vo.ParamMarketingVo;
import cn.com.yusys.yusp.system.dao.ParamMarketingDao;
import cn.com.yusys.yusp.system.domain.entity.ParamMarketingEntity;
import cn.com.yusys.yusp.system.domain.query.ParamMarketingQuery;
import cn.com.yusys.yusp.system.service.ParamMarketingService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamMarketingServiceImpl
implements ParamMarketingService {
    @Autowired
    private ParamMarketingDao paramMarketingMapper;

    @Override
    public int create(ParamMarketingBo paramMarketingBo) throws Exception {
        ParamMarketingEntity paramMarketingEntity = new ParamMarketingEntity();
        BeanUtils.beanCopy((Object)paramMarketingBo, (Object)paramMarketingEntity);
        paramMarketingEntity.setUserId(SessionUtils.getUserId());
        paramMarketingEntity.setMarketId(StringUtils.getUUID());
        paramMarketingEntity.setLastChgUser(SessionUtils.getUserId());
        paramMarketingEntity.setLastChgDt(DateUtils.formatDateTimeByDef());
        return this.paramMarketingMapper.insert(paramMarketingEntity);
    }

    @Override
    public ParamMarketingVo show(ParamMarketingQuery paramMarketingQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramMarketingQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ marketId=" + paramMarketingQuery.getMarketId() + " ]");
        }
        return (ParamMarketingVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamMarketingVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamMarketingEntity> list = this.paramMarketingMapper.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamMarketingVo> list(QueryModel model) throws Exception {
        List<ParamMarketingEntity> list = this.paramMarketingMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, ParamMarketingVo.class);
        return voList;
    }

    @Override
    public int update(ParamMarketingBo paramMarketingBo) throws Exception {
        ParamMarketingEntity paramMarketingEntity = new ParamMarketingEntity();
        BeanUtils.beanCopy((Object)paramMarketingBo, (Object)paramMarketingEntity);
        paramMarketingEntity.setLastChgUser(SessionUtils.getUserId());
        paramMarketingEntity.setLastChgDt(DateUtils.formatDateTimeByDef());
        paramMarketingEntity.setUserId(SessionUtils.getUserId());
        paramMarketingEntity.setOrgId(IcspSessionUtils.getCurrentOrgId());
        return this.paramMarketingMapper.updateByPrimaryKey(paramMarketingEntity);
    }

    @Override
    public int delete(String marketId) throws Exception {
        return this.paramMarketingMapper.deleteByPrimaryKey(marketId);
    }

    @Override
    public ParamMarketingVo showLastUpdTimeDesc(ParamMarketingQuery paramMarketingQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramMarketingQuery);
        model.setSort("lastChgDt desc");
        List<ParamMarketingVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return list.get(0);
    }
}

