/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamInitBussDateBo;
import cn.com.yusys.yusp.param.vo.ParamInitBussDateVo;
import cn.com.yusys.yusp.system.dao.ParamInitBussDateDao;
import cn.com.yusys.yusp.system.domain.entity.ParamInitBussDateEntity;
import cn.com.yusys.yusp.system.domain.entity.ParamOrgBussDateEntity;
import cn.com.yusys.yusp.system.domain.query.ParamInitBussDateQuery;
import cn.com.yusys.yusp.system.service.ParamInitBussDateService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamInitBussDateServiceImpl
implements ParamInitBussDateService {
    @Autowired
    private ParamInitBussDateDao paramInitBussDateDao;

    @Override
    public int create(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        ParamInitBussDateEntity paramInitBussDateEntity = new ParamInitBussDateEntity();
        BeanUtils.beanCopy((Object)paramInitBussDateBo, (Object)paramInitBussDateEntity);
        return this.paramInitBussDateDao.insert(paramInitBussDateEntity);
    }

    @Override
    public ParamInitBussDateVo show(ParamInitBussDateQuery paramInitBussDateQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramInitBussDateQuery);
        List<ParamInitBussDateVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ bussDate=" + paramInitBussDateQuery.getBussDate() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=ParamInitBussDateVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamInitBussDateEntity> list = this.paramInitBussDateDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamInitBussDateVo> list(QueryModel model) throws Exception {
        List<ParamInitBussDateEntity> list = this.paramInitBussDateDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamInitBussDateVo.class);
        return listVo;
    }

    @Override
    public int update(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        ParamInitBussDateEntity paramInitBussDateEntity = new ParamInitBussDateEntity();
        BeanUtils.beanCopy((Object)paramInitBussDateBo, (Object)paramInitBussDateEntity);
        return this.paramInitBussDateDao.updateByPrimaryKey(paramInitBussDateEntity);
    }

    @Override
    public int delete(String bussDate) throws Exception {
        return this.paramInitBussDateDao.deleteByPrimaryKey(bussDate);
    }

    @Override
    public int initBussDate(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        String bussYear = paramInitBussDateBo.getBussYear();
        if (StringUtils.isEmpty((CharSequence)bussYear)) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u5e74\u4efd\uff01");
        }
        this.paramInitBussDateDao.deleteYear(bussYear);
        int year = Integer.parseInt(bussYear);
        String firstDay = bussYear + "0101";
        int totalDays = 365;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            totalDays = 366;
        }
        ArrayList<ParamInitBussDateEntity> initList = new ArrayList<ParamInitBussDateEntity>();
        Date everyDay = DateUtils.parseDate((String)firstDay, (String)"yyyyMMdd");
        ParamInitBussDateEntity entity = null;
        String lastChgUser = SessionUtils.getUserId();
        String lastChgDt = DateUtils.formatDateByDef();
        for (int day = 0; day < totalDays; ++day) {
            String bussDate = DateUtils.formatDate((Date)everyDay, (String)"yyyyMMdd");
            String weekDay = DateUtils.formatDate((Date)everyDay, (String)"EEEE");
            String dateType = "1";
            if ("\u661f\u671f\u516d".equals(weekDay) || "\u661f\u671f\u65e5".equals(weekDay)) {
                dateType = "3";
            }
            entity = new ParamInitBussDateEntity();
            entity.setBussDate(bussDate);
            entity.setDateType(dateType);
            entity.setLastChgUser(lastChgUser);
            entity.setLastChgDt(lastChgDt);
            initList.add(entity);
            everyDay = DateUtils.getTomorrow((Date)everyDay, (String)"yyyyMMdd");
        }
        return this.paramInitBussDateDao.batchInsert(initList);
    }

    @Override
    public int setHoliday(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        String bussYear = paramInitBussDateBo.getBussYear();
        if (StringUtils.isEmpty((CharSequence)bussYear)) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u5e74\u4efd\uff01");
        }
        ParamInitBussDateEntity paramEntity = new ParamInitBussDateEntity();
        paramEntity.setBussDate(bussYear);
        List<ParamInitBussDateEntity> entities = this.paramInitBussDateDao.queryYear(paramEntity);
        if (null == entities || entities.size() < 365) {
            throw new IcspException("500", "\u8bf7\u521d\u59cb\u5316\u5e74\u4efd\u7684\u6240\u6709\u8425\u4e1a\u65e5\u671f");
        }
        List boList = paramInitBussDateBo.getBoList();
        if (null == boList || boList.size() == 0) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8425\u4e1a\u65e5\u671f");
        }
        ArrayList<ParamInitBussDateEntity> updateEntity = new ArrayList<ParamInitBussDateEntity>();
        ArrayList<ParamOrgBussDateEntity> updateDateEntity = new ArrayList<ParamOrgBussDateEntity>();
        String lastChgUser = SessionUtils.getUserId();
        String lastChgDt = DateUtils.formatDateByDef();
        ParamInitBussDateEntity entity = null;
        ParamOrgBussDateEntity bussDateEntity = null;
        for (ParamInitBussDateBo bo : boList) {
            entity = new ParamInitBussDateEntity();
            entity.setBussDate(bo.getBussDate());
            entity.setDateType(bo.getDateType());
            entity.setLastChgUser(lastChgUser);
            entity.setLastChgDt(lastChgDt);
            updateEntity.add(entity);
            bussDateEntity = new ParamOrgBussDateEntity();
            bussDateEntity.setBussDate(bo.getBussDate());
            bussDateEntity.setDateType(bo.getDateType());
            bussDateEntity.setLastChgUser(lastChgUser);
            bussDateEntity.setLastChgDt(lastChgDt);
            bussDateEntity.setIsBuss("N");
            if ("1".equals(bo.getDateType())) {
                bussDateEntity.setIsBuss("Y");
            }
            updateDateEntity.add(bussDateEntity);
        }
        this.paramInitBussDateDao.batchUpdate(updateEntity);
        this.paramInitBussDateDao.batchUpdateDate(updateDateEntity);
        return 0;
    }

    @Override
    public String queryYear(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        String bussYear = paramInitBussDateBo.getBussYear();
        if (StringUtils.isEmpty((CharSequence)bussYear)) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u67e5\u8be2\u5e74\u4efd\uff01");
        }
        ParamInitBussDateEntity paramEntity = new ParamInitBussDateEntity();
        paramEntity.setBussDate(bussYear);
        List<ParamInitBussDateEntity> entities = this.paramInitBussDateDao.queryYear(paramEntity);
        if (null == entities || entities.size() < 365) {
            throw new IcspException("500", "\u8bf7\u751f\u6210" + bussYear + "\u5e74\u4efd\u7684\u6240\u6709\u8425\u4e1a\u65e5\u671f");
        }
        int bussYearInt = Integer.parseInt(bussYear);
        if ((bussYearInt % 4 == 0 && bussYearInt % 100 != 0 || bussYearInt % 400 == 0) && 366 == entities.size()) {
            return "success";
        }
        if (365 == entities.size()) {
            return "success";
        }
        return "fail";
    }

    @Override
    public List<ParamInitBussDateVo> queryMonth(ParamInitBussDateBo paramInitBussDateBo) throws Exception {
        String bussYear = paramInitBussDateBo.getBussYear();
        if (StringUtils.isEmpty((CharSequence)bussYear)) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u67e5\u8be2\u6708\u4efd\uff01");
        }
        ParamInitBussDateEntity paramEntity = new ParamInitBussDateEntity();
        paramEntity.setBussDate(bussYear);
        List<ParamInitBussDateEntity> list = this.paramInitBussDateDao.queryYear(paramEntity);
        if (null == list || list.size() == 0) {
            throw new IcspException("500", "\u8bf7\u751f\u6210\u5e74\u4efd\u57fa\u7840\u8425\u4e1a\u65e5\u671f");
        }
        List listVo = (List)BeanUtils.beansCopy(list, ParamInitBussDateVo.class);
        return listVo;
    }
}

