/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.param.bo.ParamTradeBo;
import cn.com.yusys.yusp.param.vo.ParamTradeVo;
import cn.com.yusys.yusp.system.domain.query.ParamTradeQuery;
import cn.com.yusys.yusp.system.service.ParamTradeService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paramTrade"})
public class ParamTradeController {
    private static final Logger logger = LoggerFactory.getLogger(ParamTradeController.class);
    @Autowired
    private ParamTradeService paramTradeService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ParamTradeBo> request) throws Exception {
        ParamTradeBo paramTrade = (ParamTradeBo)request.getBody();
        try {
            int result = this.paramTradeService.create(paramTrade);
            return IcspResultDto.success((Object)result);
        }
        catch (Exception e) {
            return IcspResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<ParamTradeVo> show(@RequestBody IcspRequest<ParamTradeQuery> request) throws Exception {
        ParamTradeQuery paramTradeQuery = (ParamTradeQuery)request.getBody();
        ParamTradeVo result = this.paramTradeService.show(paramTradeQuery);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<ParamTradeVo>> index(@RequestBody IcspRequest<ParamTradeQuery> request) throws Exception {
        List<ParamTradeVo> list = this.paramTradeService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<ParamTradeVo>> list(@RequestBody IcspRequest<ParamTradeQuery> request) throws Exception {
        List<ParamTradeVo> list = this.paramTradeService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ParamTradeBo> request) throws Exception {
        ParamTradeBo paramTradeBo = (ParamTradeBo)request.getBody();
        int result = this.paramTradeService.update(paramTradeBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ParamTradeQuery> request) throws Exception {
        ParamTradeQuery paramTradeQuery = (ParamTradeQuery)request.getBody();
        int result = this.paramTradeService.delete(paramTradeQuery.getTradeId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/showAndSign"})
    public IcspResultDto<ParamTradeVo> showAndSign(@RequestBody IcspRequest<ParamTradeQuery> request) throws Exception {
        ParamTradeVo result = this.paramTradeService.showAndSign(request);
        return IcspResultDto.success((Object)result);
    }
}

