/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.param.bo.ParamSysBo;
import cn.com.yusys.yusp.param.dto.ParamSysDto;
import cn.com.yusys.yusp.param.vo.ParamSysVo;
import cn.com.yusys.yusp.system.domain.query.ParamSysQuery;
import cn.com.yusys.yusp.system.service.ParamSysService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paramSys"})
public class ParamSysController {
    private static final Logger logger = LoggerFactory.getLogger(ParamSysController.class);
    @Autowired
    private ParamSysService paramSysService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ParamSysBo> request) throws Exception {
        ParamSysBo paramSysBo = (ParamSysBo)request.getBody();
        int result = this.paramSysService.create(paramSysBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<ParamSysVo> show(@RequestBody IcspRequest<ParamSysQuery> request) throws Exception {
        ParamSysQuery paramSysQuery = (ParamSysQuery)request.getBody();
        ParamSysVo result = this.paramSysService.show(paramSysQuery);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/rateCheck"})
    public IcspResultDto<ParamSysDto> rateCheck(@RequestBody IcspRequest<ParamSysBo> request) throws Exception {
        ParamSysBo bo = (ParamSysBo)request.getBody();
        ParamSysDto result = this.paramSysService.rateCheck(bo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<ParamSysVo>> index(@RequestBody IcspRequest<ParamSysQuery> request) throws Exception {
        List<ParamSysVo> list = this.paramSysService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<ParamSysVo>> list(@RequestBody IcspRequest<ParamSysQuery> request) throws Exception {
        List<ParamSysVo> list = this.paramSysService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ParamSysBo> request) throws Exception {
        ParamSysBo paramSysBo = (ParamSysBo)request.getBody();
        int result = this.paramSysService.update(paramSysBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ParamSysQuery> request) throws Exception {
        ParamSysQuery paramSysQuery = (ParamSysQuery)request.getBody();
        int result = this.paramSysService.delete(paramSysQuery.getSysId());
        return IcspResultDto.success((Object)result);
    }
}

