/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.param.bo.ParamMarketingBo;
import cn.com.yusys.yusp.param.vo.ParamMarketingVo;
import cn.com.yusys.yusp.system.domain.query.ParamMarketingQuery;
import cn.com.yusys.yusp.system.service.ParamMarketingService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paramMarketing"})
public class ParamMarketingController {
    private static final Logger logger = LoggerFactory.getLogger(ParamMarketingController.class);
    @Autowired
    private ParamMarketingService paramMarketingService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ParamMarketingBo> request) throws Exception {
        ParamMarketingBo paramMarketing = (ParamMarketingBo)request.getBody();
        paramMarketing.setOrgId(request.getTradeHead().getOrgId());
        int result = this.paramMarketingService.create(paramMarketing);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<ParamMarketingVo> show(@RequestBody IcspRequest<ParamMarketingQuery> request) throws Exception {
        ParamMarketingQuery paramMarketing = (ParamMarketingQuery)request.getBody();
        ParamMarketingVo result = this.paramMarketingService.show(paramMarketing);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<ParamMarketingVo>> index(@RequestBody IcspRequest<ParamMarketingQuery> request) throws Exception {
        List<ParamMarketingVo> list = this.paramMarketingService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<ParamMarketingVo>> list(@RequestBody IcspRequest<ParamMarketingQuery> request) throws Exception {
        List<ParamMarketingVo> list = this.paramMarketingService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ParamMarketingBo> request) throws Exception {
        ParamMarketingBo paramMarketing = (ParamMarketingBo)request.getBody();
        int result = this.paramMarketingService.update(paramMarketing);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ParamMarketingQuery> request) throws Exception {
        ParamMarketingQuery paramMarketing = (ParamMarketingQuery)request.getBody();
        int result = this.paramMarketingService.delete(paramMarketing.getMarketId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/showLastUpdTimeDesc"})
    public IcspResultDto<ParamMarketingVo> showLastUpdTimeDesc(@RequestBody IcspRequest<ParamMarketingQuery> request) throws Exception {
        ParamMarketingQuery paramMarketing = (ParamMarketingQuery)request.getBody();
        ParamMarketingVo result = this.paramMarketingService.showLastUpdTimeDesc(paramMarketing);
        return IcspResultDto.success((Object)result);
    }
}

