/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamUsgTransBo;
import cn.com.yusys.yusp.param.vo.ParamUsgTransVo;
import cn.com.yusys.yusp.system.dao.ParamUsgTransDao;
import cn.com.yusys.yusp.system.domain.entity.ParamUsgTransEntity;
import cn.com.yusys.yusp.system.domain.query.ParamUsgTransQuery;
import cn.com.yusys.yusp.system.service.ParamUsgTransService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamUsgTransServiceImpl
implements ParamUsgTransService {
    @Autowired
    private ParamUsgTransDao paramUsgTransDao;

    @Override
    public int create(ParamUsgTransBo paramUsgTransBo) throws Exception {
        paramUsgTransBo.setTransId(StringUtils.getUUID());
        ParamUsgTransEntity paramUsgTransEntity = new ParamUsgTransEntity();
        BeanUtils.beanCopy((Object)paramUsgTransBo, (Object)paramUsgTransEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgTransEntity.setCreateDate(currentDate);
        paramUsgTransEntity.setCreateTime(currentTime);
        paramUsgTransEntity.setCreateTellerNo(userId);
        paramUsgTransEntity.setUpdateDate(currentDate);
        paramUsgTransEntity.setUpdateTime(currentTime);
        paramUsgTransEntity.setUpdateTellerNo(userId);
        return this.paramUsgTransDao.insert(paramUsgTransEntity);
    }

    @Override
    public ParamUsgTransVo show(ParamUsgTransQuery paramUsgTransQuery) throws Exception {
        String transId = paramUsgTransQuery.getTransId();
        if (StringUtils.isEmpty((CharSequence)transId)) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramUsgTransQuery);
        List<ParamUsgTransVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ productId=" + paramUsgTransQuery.getProductId() + " productType=" + paramUsgTransQuery.getProductType() + " transType=" + paramUsgTransQuery.getTransType() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=ParamUsgTransVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamUsgTransEntity> list = this.paramUsgTransDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamUsgTransVo> list(QueryModel model) throws Exception {
        List<ParamUsgTransEntity> list = this.paramUsgTransDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamUsgTransVo.class);
        return listVo;
    }

    @Override
    public int update(ParamUsgTransBo paramUsgTransBo) throws Exception {
        ParamUsgTransEntity paramUsgTransEntity = new ParamUsgTransEntity();
        BeanUtils.beanCopy((Object)paramUsgTransBo, (Object)paramUsgTransEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgTransEntity.setUpdateDate(currentDate);
        paramUsgTransEntity.setUpdateTime(currentTime);
        paramUsgTransEntity.setUpdateTellerNo(userId);
        return this.paramUsgTransDao.updateByPrimaryKey(paramUsgTransEntity);
    }

    @Override
    public int delete(String productId, String productType, String transType) throws Exception {
        return this.paramUsgTransDao.deleteByPrimaryKey(productId, productType, transType);
    }
}

