/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamUsgProductBo;
import cn.com.yusys.yusp.param.vo.ParamUsgProductVo;
import cn.com.yusys.yusp.system.dao.ParamUsgProductDao;
import cn.com.yusys.yusp.system.domain.entity.ParamUsgProductEntity;
import cn.com.yusys.yusp.system.domain.query.ParamUsgProductQuery;
import cn.com.yusys.yusp.system.service.ParamUsgProductService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamUsgProductServiceImpl
implements ParamUsgProductService {
    @Autowired
    private ParamUsgProductDao paramUsgProductDao;

    @Override
    public int create(ParamUsgProductBo paramUsgProductBo) throws Exception {
        paramUsgProductBo.setProductId(StringUtils.getUUID());
        ParamUsgProductEntity paramUsgProductEntity = new ParamUsgProductEntity();
        BeanUtils.beanCopy((Object)paramUsgProductBo, (Object)paramUsgProductEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgProductEntity.setCreateDate(currentDate);
        paramUsgProductEntity.setCreateTime(currentTime);
        paramUsgProductEntity.setCreateTellerNo(userId);
        paramUsgProductEntity.setUpdateDate(currentDate);
        paramUsgProductEntity.setUpdateTime(currentTime);
        paramUsgProductEntity.setUpdateTellerNo(userId);
        return this.paramUsgProductDao.insert(paramUsgProductEntity);
    }

    @Override
    public ParamUsgProductVo show(ParamUsgProductQuery paramUsgProductQuery) throws Exception {
        if (StringUtils.isEmpty((CharSequence)paramUsgProductQuery.getProductId())) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramUsgProductQuery);
        List<ParamUsgProductVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ productId=" + paramUsgProductQuery.getProductId() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=ParamUsgProductVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamUsgProductEntity> list = this.paramUsgProductDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamUsgProductVo> list(QueryModel model) throws Exception {
        List<ParamUsgProductEntity> list = this.paramUsgProductDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamUsgProductVo.class);
        return listVo;
    }

    @Override
    public int update(ParamUsgProductBo paramUsgProductBo) throws Exception {
        ParamUsgProductEntity paramUsgProductEntity = new ParamUsgProductEntity();
        BeanUtils.beanCopy((Object)paramUsgProductBo, (Object)paramUsgProductEntity);
        String userId = SessionUtils.getUserId();
        String currentDate = DateUtils.formatDateByDef();
        String currentTime = DateUtils.formatDate((String)"HHmmssSSS");
        paramUsgProductEntity.setUpdateDate(currentDate);
        paramUsgProductEntity.setUpdateTime(currentTime);
        paramUsgProductEntity.setUpdateTellerNo(userId);
        return this.paramUsgProductDao.updateByPrimaryKey(paramUsgProductEntity);
    }

    @Override
    public int delete(String productId) throws Exception {
        return this.paramUsgProductDao.deleteByPrimaryKey(productId);
    }
}

