/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.system.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.ParamSysBo;
import cn.com.yusys.yusp.param.vo.ParamSysVo;
import cn.com.yusys.yusp.system.dao.ParamSysDao;
import cn.com.yusys.yusp.system.domain.entity.ParamSysEntity;
import cn.com.yusys.yusp.system.domain.query.ParamSysQuery;
import cn.com.yusys.yusp.system.service.ParamSysService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamSysServiceImpl
implements ParamSysService {
    @Autowired
    private ParamSysDao paramSysMapper;

    @Override
    public int create(ParamSysBo paramSysBo) throws Exception {
        ParamSysEntity paramSysEntity = new ParamSysEntity();
        BeanUtils.beanCopy((Object)paramSysBo, (Object)paramSysEntity);
        paramSysEntity.setSysId(StringUtils.getUUID());
        paramSysEntity.setLastChgUser(SessionUtils.getUserId());
        paramSysEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.paramSysMapper.insert(paramSysEntity);
    }

    @Override
    public ParamSysVo show(ParamSysQuery paramSysQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramSysQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ sysId=" + paramSysQuery.getSysId() + " ]");
        }
        return (ParamSysVo)list.get(0);
    }

    @MyPageAble(returnVo=ParamSysVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamSysEntity> list = this.paramSysMapper.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamSysVo> list(QueryModel model) throws Exception {
        List<ParamSysEntity> list = this.paramSysMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, ParamSysVo.class);
        return voList;
    }

    @Override
    public int update(ParamSysBo paramSysBo) throws Exception {
        ParamSysEntity paramSysEntity = new ParamSysEntity();
        BeanUtils.beanCopy((Object)paramSysBo, (Object)paramSysEntity);
        paramSysEntity.setLastChgUser(SessionUtils.getUserId());
        paramSysEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.paramSysMapper.updateByPrimaryKey(paramSysEntity);
    }

    @Override
    public int delete(String sysId) throws Exception {
        return this.paramSysMapper.deleteByPrimaryKey(sysId);
    }
}

