/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.RuleTradeElementBo;
import cn.com.yusys.yusp.param.vo.RuleTradeElementVo;
import cn.com.yusys.yusp.rule.dao.RuleTradeElementDao;
import cn.com.yusys.yusp.rule.domain.entity.RulePublicElementEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleTradeElementEntity;
import cn.com.yusys.yusp.rule.domain.query.RuleTradeElementQuery;
import cn.com.yusys.yusp.rule.service.RuleTradeElementService;
import com.github.pagehelper.PageHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleTradeElementServiceImpl
implements RuleTradeElementService {
    private static final Logger logger = LoggerFactory.getLogger(RuleTradeElementServiceImpl.class);
    @Autowired
    private RuleTradeElementDao ruleTradeElementMapper;

    @Override
    public int create(RuleTradeElementBo ruleTradeElementBo) throws Exception {
        this.beforeCheck(ruleTradeElementBo);
        RuleTradeElementEntity resp = this.ruleTradeElementMapper.show(ruleTradeElementBo.getTradeCode(), ruleTradeElementBo.getFieldCode());
        if (resp != null) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801[" + ruleTradeElementBo.getFieldCode() + "]\u5728\u4ea4\u6613[" + ruleTradeElementBo.getTradeCode() + "]\u5df2\u5b58\u5728!");
        }
        ruleTradeElementBo.setLastChgUser(SessionUtils.getUserId());
        ruleTradeElementBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleTradeElementEntity ruleTradeElement = new RuleTradeElementEntity();
        BeanUtils.beanCopy((Object)ruleTradeElementBo, (Object)ruleTradeElement);
        return this.ruleTradeElementMapper.insert(ruleTradeElement);
    }

    @Override
    public int update(RuleTradeElementBo ruleTradeElementBo) throws Exception {
        this.beforeCheck(ruleTradeElementBo);
        RuleTradeElementEntity resp = this.ruleTradeElementMapper.show(ruleTradeElementBo.getTradeCode(), ruleTradeElementBo.getFieldCode());
        if (resp == null) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801[" + ruleTradeElementBo.getFieldCode() + "]\u5728\u4ea4\u6613[" + ruleTradeElementBo.getTradeCode() + "]\u4e0d\u5b58\u5728!");
        }
        ruleTradeElementBo.setLastChgUser(SessionUtils.getUserId());
        ruleTradeElementBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleTradeElementEntity ruleTradeElement = new RuleTradeElementEntity();
        BeanUtils.beanCopy((Object)ruleTradeElementBo, (Object)ruleTradeElement);
        return this.ruleTradeElementMapper.updateByPrimaryKey(ruleTradeElement);
    }

    private void beforeCheck(RuleTradeElementBo ruleTradeElementBo) {
        if (StringUtils.isEmpty((CharSequence)ruleTradeElementBo.getTradeCode())) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleTradeElementBo.getFieldCode())) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleTradeElementBo.getFieldName())) {
            throw new IcspException("500", "\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public int delete(String tradeCode, String fieldCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tradeCode)) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)fieldCode)) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RuleTradeElementEntity resp = this.ruleTradeElementMapper.show(tradeCode, fieldCode);
        if (resp == null) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801[" + fieldCode + "]\u5728\u4ea4\u6613[" + tradeCode + "]\u4e0d\u5b58\u5728!");
        }
        return this.ruleTradeElementMapper.deleteByPrimaryKey(tradeCode, fieldCode);
    }

    @Override
    public List<RuleTradeElementVo> index(QueryModel model) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((RuleTradeElementQuery)model.getCondition()).getTradeCode())) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<RuleTradeElementEntity> list = this.ruleTradeElementMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleTradeElementVo.class);
        PageHelper.clearPage();
        return voList;
    }

    @Override
    public List<RuleTradeElementVo> list(QueryModel model) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((RuleTradeElementQuery)model.getCondition()).getTradeCode())) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<RuleTradeElementEntity> list = this.ruleTradeElementMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleTradeElementVo.class);
        return voList;
    }

    @Override
    public RuleTradeElementVo show(String tradeCode, String fieldCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tradeCode)) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)fieldCode)) {
            throw new IcspException("500", "\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RuleTradeElementVo ruleTradeElementVo = new RuleTradeElementVo();
        BeanUtils.beanCopy((Object)this.ruleTradeElementMapper.show(tradeCode, fieldCode), (Object)ruleTradeElementVo);
        return ruleTradeElementVo;
    }

    @Override
    public Integer readXml(String tradeCode, String dataXml) throws Exception {
        int result = 0;
        if (StringUtils.nonEmpty((CharSequence)dataXml)) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(dataXml.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("") || !line.contains("fox-text-item") && !line.contains("fox-select-item") && !line.contains("fox-date-item") && !line.contains("fox-number-item") || !line.contains("<fox") || !line.contains("</fox")) continue;
                String codeB = line.substring(line.indexOf("v-model=\"") + 9);
                String code = codeB.substring(0, codeB.indexOf("\""));
                String name = line.substring(line.indexOf(">") + 1, line.indexOf("</fox"));
                RuleTradeElementEntity ruleTradeElement = new RuleTradeElementEntity();
                ruleTradeElement.setTradeCode(tradeCode);
                ruleTradeElement.setFieldCode(code);
                ruleTradeElement.setFieldName(name);
                ruleTradeElement.setLastChgUser(SessionUtils.getUserId());
                ruleTradeElement.setLastChgDt(DateUtils.formatDateTimeByDef());
                int num = this.ruleTradeElementMapper.insert(ruleTradeElement);
                if (num <= 0) continue;
                ++result;
            }
            logger.info("\u65b0\u589e\u6570\u636e" + result + "\u6761");
        }
        return result;
    }

    @Override
    public List<RulePublicElementEntity> queryPublic() throws Exception {
        return this.ruleTradeElementMapper.queryPublic();
    }
}

