/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.util.IcspSessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.rule.dao.ParamRoleTradeDao;
import cn.com.yusys.yusp.rule.domain.bo.CreateParamRoleTradeBo;
import cn.com.yusys.yusp.rule.domain.bo.ParamRoleTradeBo;
import cn.com.yusys.yusp.rule.domain.entity.ParamRoleTradeEntity;
import cn.com.yusys.yusp.rule.domain.query.ParamRoleTradeQuery;
import cn.com.yusys.yusp.rule.domain.vo.ParamRoleTradeVo;
import cn.com.yusys.yusp.rule.service.ParamRoleTradeService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParamRoleTradeServiceImpl
implements ParamRoleTradeService {
    @Autowired
    private ParamRoleTradeDao paramRoleTradeDao;

    @Override
    public int create(CreateParamRoleTradeBo paramRoleTradeBo) throws Exception {
        List<Map<String, String>> tradeList = paramRoleTradeBo.getTradeList();
        if (tradeList == null || tradeList.isEmpty()) {
            ParamRoleTradeEntity paramRoleTradeEntity = new ParamRoleTradeEntity();
            paramRoleTradeEntity.setChannelId(paramRoleTradeBo.getChannelId());
            paramRoleTradeEntity.setRoleId(paramRoleTradeBo.getRoleId());
            this.paramRoleTradeDao.delete(paramRoleTradeEntity);
        } else {
            ParamRoleTradeEntity delEntity = new ParamRoleTradeEntity();
            delEntity.setChannelId(paramRoleTradeBo.getChannelId());
            delEntity.setRoleId(paramRoleTradeBo.getRoleId());
            this.paramRoleTradeDao.delete(delEntity);
            for (Map<String, String> tradeMap : tradeList) {
                ParamRoleTradeEntity paramRoleTradeEntity = new ParamRoleTradeEntity();
                paramRoleTradeEntity.setRoleTradeId(StringUtils.getUUID());
                paramRoleTradeEntity.setChannelId(paramRoleTradeBo.getChannelId());
                paramRoleTradeEntity.setRoleId(paramRoleTradeBo.getRoleId());
                paramRoleTradeEntity.setTradeId(tradeMap.get("tradeCode"));
                paramRoleTradeEntity.setAuthType("1");
                paramRoleTradeEntity.setLastChgUser(IcspSessionUtils.getUserId());
                paramRoleTradeEntity.setLastChgDt(DateUtils.getCurrDateTimeStr());
                this.paramRoleTradeDao.insert(paramRoleTradeEntity);
            }
        }
        return tradeList.size();
    }

    @Override
    public CreateParamRoleTradeBo show(ParamRoleTradeQuery paramRoleTradeQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)paramRoleTradeQuery);
        List<ParamRoleTradeEntity> list = this.paramRoleTradeDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            return null;
        }
        CreateParamRoleTradeBo createParamRoleTradeBo = new CreateParamRoleTradeBo();
        ArrayList<Map<String, String>> tradeList = new ArrayList<Map<String, String>>();
        for (ParamRoleTradeEntity paramRoleTradeVo : list) {
            HashMap<String, String> tradeMap = new HashMap<String, String>();
            tradeMap.put("tradeName", paramRoleTradeVo.getTradeName());
            tradeMap.put("tradeCode", paramRoleTradeVo.getTradeId());
            tradeList.add(tradeMap);
        }
        createParamRoleTradeBo.setTradeList(tradeList);
        createParamRoleTradeBo.setRoleId(paramRoleTradeQuery.getRoleId());
        createParamRoleTradeBo.setChannelId(paramRoleTradeQuery.getChannelId());
        return createParamRoleTradeBo;
    }

    @MyPageAble(returnVo=ParamRoleTradeVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<ParamRoleTradeEntity> list = this.paramRoleTradeDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<ParamRoleTradeVo> list(QueryModel model) throws Exception {
        List<ParamRoleTradeEntity> list = this.paramRoleTradeDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, ParamRoleTradeVo.class);
        return listVo;
    }

    @Override
    public int update(ParamRoleTradeBo paramRoleTradeBo) throws Exception {
        ParamRoleTradeEntity paramRoleTradeEntity = new ParamRoleTradeEntity();
        BeanUtils.beanCopy((Object)paramRoleTradeBo, (Object)paramRoleTradeEntity);
        return this.paramRoleTradeDao.updateByPrimaryKey(paramRoleTradeEntity);
    }

    @Override
    public int delete() throws Exception {
        return this.paramRoleTradeDao.deleteByPrimaryKey();
    }
}

