/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.param.bo.RuleEventBo;
import cn.com.yusys.yusp.rule.service.RuleEventService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ruleEvent"})
public class RuleEventController {
    private static final Logger logger = LoggerFactory.getLogger(RuleEventController.class);
    @Autowired
    private RuleEventService ruleEventService;

    @PostMapping(value={"/getEventsByTradeCode"})
    @ApiOperation(value="\u67e5\u8be2\u516c\u5171\u62a5\u6587")
    public IcspResultDto<List<RuleEventBo>> getEventsByTradeCode(@RequestBody String tradeCode) throws Exception {
        logger.info("\u8bf7\u6c42URL: /api/ruleEvent/getEventsByTradeCode");
        List<RuleEventBo> result = this.ruleEventService.getEventsByTradeCode(tradeCode);
        return IcspResultDto.success(result);
    }

    @PostMapping(value={"/listEventsByTradeCode"})
    @ApiOperation(value="\u67e5\u8be2\u516c\u5171\u62a5\u6587")
    public IcspResultDto<List<RuleEventBo>> listEventsByTradeCode(@RequestBody IcspRequest<Map<String, Object>> request) throws Exception {
        logger.info("\u8bf7\u6c42URL: /api/ruleEvent/listEventsByTradeCode");
        List<RuleEventBo> result = this.ruleEventService.listEventsByTradeCode(((Map)request.getBody()).getOrDefault("tradeCode", "").toString());
        return IcspResultDto.success(result);
    }
}

