/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.check;

import cn.com.yusys.yusp.rule.check.RuleObject;
import cn.com.yusys.yusp.rule.dao.RuleDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class RuleBean {
    static final String CACHE_KEY = "CLOUD-BANK-RULE";
    private static final Logger logger = LoggerFactory.getLogger(RuleBean.class);
    @Autowired
    RuleDao mapper;
    ReentrantLock lock = new ReentrantLock();

    @Cacheable(value={"CLOUD-BANK-RULE"}, key="#serviceId", unless="#result == null")
    public RuleObject getRuleObjectByServiceId(String serviceId) {
        RuleObject ruleObject = this.createRuleObject(null, serviceId);
        return ruleObject;
    }

    @Cacheable(value={"CLOUD-BANK-RULE"}, key="#serviceIdSceneCode", unless="#result == null")
    public RuleObject getRuleObjectByServiceIdSceneCode(String serviceIdSceneCode) {
        String sceneCode = serviceIdSceneCode.split(",")[0];
        String serviceId = serviceIdSceneCode.split(",")[1];
        RuleObject ruleObject = this.createRuleObject(sceneCode, serviceId);
        return ruleObject;
    }

    private RuleObject createRuleObject(String sceneCode, String serviceId) {
        List listAuthEvent;
        List listRuleEvent;
        List listRule = this.mapper.queryRule(serviceId, sceneCode);
        if (listRule.isEmpty()) {
            return new RuleObject();
        }
        ArrayList listRuleId = new ArrayList(listRule.size());
        HashMap<String, Map> mapRuleInfo = new HashMap<String, Map>();
        listRule.forEach(m -> {
            String ruleId = (String)m.get("rule_id");
            listRuleId.add(ruleId);
            mapRuleInfo.put(ruleId, (Map)m);
        });
        List listCondition = this.mapper.queryConditions(listRuleId);
        HashMap<String, List> mapCondition = new HashMap<String, List>();
        HashMap<String, List> mapConditionParam = new HashMap<String, List>();
        if (!listCondition.isEmpty()) {
            listCondition.forEach(map -> mapCondition.compute((String)map.get("rule_id"), (key, value) -> {
                if (value == null) {
                    value = new ArrayList<Map>();
                }
                value.add(map);
                return value;
            }));
            List listParam = this.mapper.queryConditionParam(listRuleId);
            listParam.forEach(map -> mapConditionParam.compute((String)map.get("cond_id"), (key, value) -> {
                if (value == null) {
                    value = new ArrayList<Map>();
                }
                value.add(map);
                return value;
            }));
        }
        if ((listRuleEvent = this.mapper.queryRuleEvent(listRuleId)).isEmpty()) {
            logger.warn("\u4ea4\u6613\u573a\u666f[{}]\u670d\u52a1\u7801[{}]\u89c4\u5219\u7684\u4e8b\u4ef6\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u89c4\u5219", (Object)sceneCode, (Object)serviceId);
            return new RuleObject();
        }
        ArrayList<String> listAuthEventId = new ArrayList<String>();
        ArrayList<Map> priorEvent = new ArrayList<Map>();
        int i = listRuleEvent.size() - 1;
        do {
            Object eventType;
            if ("4".equals(eventType = ((Map)listRuleEvent.get(i)).get("event_type"))) {
                Map map2 = (Map)listRuleEvent.remove(i);
                listAuthEventId.add((String)map2.get("event_id"));
                continue;
            }
            if (!"2".equals(eventType) || !"1".equals(((Map)listRuleEvent.get(i)).get("trigger_type"))) continue;
            priorEvent.add((Map)listRuleEvent.remove(i));
        } while (--i >= 0);
        if (!listAuthEventId.isEmpty() && (listAuthEvent = this.mapper.queryAuthEvent(listAuthEventId)) != null) {
            priorEvent.addAll(listAuthEvent);
        }
        return new RuleObject(mapRuleInfo, mapCondition, mapConditionParam, priorEvent, listRuleEvent);
    }
}

