/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.check;

import cn.com.yusys.yusp.rule.check.RuleObject;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RuleComputer {
    private static final Logger logger;
    private static final String KEY_NEXT = "logic_next";
    private static final String KEY_ORDER = "logic_order";
    private static final String LOGIC_AND = "1";
    private static final String LOGIC_OR = "2";
    private static final String S_COND_ID = "cond_id";
    private static final String VALUE_TYPE_STR = "1";
    private static final String VALUE_TYPE_NUM = "2";
    private static final String VALUE_TYPE_AMT = "3";
    private static Map<String, Method> methods;

    public boolean computeEntry(String ruleId, RuleObject ruleObject, Map inHead, Map inBody, Map outData) {
        Map ruleInfo = ruleObject.getRuleDefine(ruleId);
        if (ruleInfo == null || ruleInfo.isEmpty()) {
            logger.info("\u89c4\u5219[{}]\u672a\u542f\u7528\u6216\u5b9a\u4e49\u4fe1\u606f\u4e3a\u7a7a", (Object)ruleId);
            return false;
        }
        if ("0".equals(ruleInfo.get("is_condition"))) {
            logger.info("\u89c4\u5219[{}]\u4e3a\u5fc5\u987b\u6267\u884c\uff0c\u8fd4\u56detrue", (Object)ruleId);
            return true;
        }
        logger.info("\u89c4\u5219[{}]\u8ba1\u7b97\u5f00\u59cb", (Object)ruleId);
        List<Map> listCond = ruleObject.getCondition(ruleId);
        if (listCond == null || listCond.isEmpty()) {
            logger.info("\u89c4\u5219[{}]\u6761\u4ef6\u5217\u8868\u4e3a\u7a7a\uff0c\u8fd4\u56defalse", (Object)ruleId);
            return false;
        }
        ArrayDeque<ComputeResult> stackRet = new ArrayDeque<ComputeResult>();
        int index = 0;
        do {
            Map cond = listCond.get(index);
            String order = (String)cond.get(KEY_ORDER);
            String logicNext = (String)cond.get(KEY_NEXT);
            String condId = (String)cond.get(S_COND_ID);
            boolean result = this.computeCond((String)cond.get("comp_class"), ruleObject.getParameter(condId), inHead, inBody, outData);
            logger.info("\u89c4\u5219[{}]\u7684\u6761\u4ef6[{}*{}*{}]\u8ba1\u7b97\u7ed3\u679c\u4e3a:{}", new Object[]{ruleId, condId, logicNext, order, result});
            String next = this.removeIgnore(ruleId, listCond, index + 1, result);
            if (next != null) {
                logicNext = next;
            }
            while (!stackRet.isEmpty()) {
                int len;
                ComputeResult cptRet = (ComputeResult)stackRet.peek();
                if (cptRet.logicOrder.length() != order.length()) break;
                stackRet.pop();
                if ("1".equals(cptRet.logicOp)) {
                    result = cptRet.ret && result;
                } else {
                    boolean bl = result = cptRet.ret || result;
                }
                if ((len = cptRet.logicOrder.length()) <= 2 || index + 1 < listCond.size() && ((String)listCond.get(index + 1).get(KEY_ORDER)).length() >= len) continue;
                order = order.substring(0, len - 2);
            }
            stackRet.push(new ComputeResult(result, order, logicNext));
        } while (++index < listCond.size());
        boolean ret = ((ComputeResult)stackRet.peek()).ret;
        logger.info("\u89c4\u5219[{}]\u8ba1\u7b97\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a:{}", (Object)ruleId, (Object)String.valueOf(ret));
        return ret;
    }

    private String removeIgnore(String ruleId, List<Map> listCond, int index, boolean result) {
        String logicNext = (String)listCond.get(index - 1).get(KEY_NEXT);
        String order = (String)listCond.get(index - 1).get(KEY_ORDER);
        block0: while (index < listCond.size() && ("2".equals(logicNext) && result || !result && "1".equals(logicNext))) {
            String nextOrder = (String)listCond.get(index).get(KEY_ORDER);
            if (order.length() > nextOrder.length()) break;
            logicNext = (String)listCond.get(index).get(KEY_NEXT);
            logger.info("\u89c4\u5219[{}]\u7684\u6761\u4ef6[{}*{}*{}]\u5ffd\u7565\u8ba1\u7b97", new Object[]{ruleId, listCond.get(index).get(S_COND_ID), logicNext, nextOrder});
            listCond.remove(index);
            if (order.length() >= nextOrder.length()) continue;
            while (index < listCond.size()) {
                nextOrder = (String)listCond.get(index).get(KEY_ORDER);
                if (order.length() >= nextOrder.length()) continue block0;
                logicNext = (String)listCond.get(index).get(KEY_NEXT);
                logger.info("\u89c4\u5219[{}]\u7684\u6761\u4ef6[{}*{}*{}]\u5ffd\u7565\u8ba1\u7b97", new Object[]{ruleId, listCond.get(index).get(S_COND_ID), logicNext, nextOrder});
                listCond.remove(index);
            }
        }
        return logicNext;
    }

    private boolean computeCond(String methodName, List<Map> listParam, Map inHead, Map inBody, Map outData) {
        try {
            Method method = methods.get(methodName);
            if (method == null) {
                logger.info("\u672a\u627e\u5230\u6761\u4ef6\u7684\u6267\u884c\u65b9\u6cd5[{}]", (Object)methodName);
                return false;
            }
            if (listParam == null || listParam.isEmpty()) {
                return (Boolean)method.invoke((Object)this, new Object[0]);
            }
            Object[] args = new Object[listParam.size()];
            for (int i = 0; i < args.length; ++i) {
                Map mapParam = listParam.get(i);
                Object paramType = mapParam.get("param_type");
                String paramPath = (String)mapParam.get("param_path");
                args[i] = "1".equals(paramType) ? paramPath : ("2".equals(paramType) ? inHead.get(paramPath) : (VALUE_TYPE_AMT.equals(paramType) ? inBody.get(paramPath) : outData.get(paramPath)));
            }
            return (Boolean)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean rCompare0(Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u7b49\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null && value == null) {
            return true;
        }
        if (valueTo == null || value == null) {
            return false;
        }
        return value.equals(valueTo);
    }

    public boolean rCompare1(String type, Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u5927\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null || value == null) {
            return false;
        }
        if ("1".equals(type)) {
            return valueTo.toString().compareTo(value.toString()) > 0;
        }
        String strTo = valueTo.toString().replace(",", "").trim();
        String str = value.toString().replace(",", "").trim();
        if (strTo.isEmpty() || str.isEmpty()) {
            return false;
        }
        if ("2".equals(type)) {
            return Double.parseDouble(strTo) > Double.parseDouble(str);
        }
        if (VALUE_TYPE_AMT.equals(type)) {
            return Double.parseDouble(strTo) > Double.parseDouble(str);
        }
        return false;
    }

    public boolean rCompare2(String type, Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u5927\u4e8e\u7b49\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null && value == null) {
            return true;
        }
        if (valueTo == null || value == null) {
            return false;
        }
        if ("1".equals(type)) {
            return valueTo.toString().compareTo(value.toString()) >= 0;
        }
        String strTo = valueTo.toString().replace(",", "").trim();
        String str = value.toString().replace(",", "").trim();
        if (strTo.isEmpty() || str.isEmpty()) {
            return false;
        }
        if ("2".equals(type)) {
            return Double.parseDouble(strTo) >= Double.parseDouble(str);
        }
        if (VALUE_TYPE_AMT.equals(type)) {
            return Double.parseDouble(strTo) >= Double.parseDouble(str);
        }
        return false;
    }

    public boolean rCompare3(String type, Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u5c0f\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null || value == null) {
            return false;
        }
        if ("1".equals(type)) {
            return valueTo.toString().compareTo(value.toString()) < 0;
        }
        String strTo = valueTo.toString().replace(",", "").trim();
        String str = value.toString().replace(",", "").trim();
        if (strTo.isEmpty() || str.isEmpty()) {
            return false;
        }
        if ("2".equals(type)) {
            return Double.parseDouble(strTo) < Double.parseDouble(str);
        }
        if (VALUE_TYPE_AMT.equals(type)) {
            return Double.parseDouble(strTo) < Double.parseDouble(str);
        }
        return false;
    }

    public boolean rCompare4(String type, Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u5c0f\u4e8e\u7b49\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null && value == null) {
            return true;
        }
        if (valueTo == null || value == null) {
            return false;
        }
        if ("1".equals(type)) {
            return valueTo.toString().compareTo(value.toString()) <= 0;
        }
        String strTo = valueTo.toString().replace(",", "").trim();
        String str = value.toString().replace(",", "").trim();
        if (strTo.isEmpty() || str.isEmpty()) {
            return false;
        }
        if ("2".equals(type)) {
            return Double.parseDouble(strTo) <= Double.parseDouble(str);
        }
        if (VALUE_TYPE_AMT.equals(type)) {
            return Double.parseDouble(strTo) <= Double.parseDouble(str);
        }
        return false;
    }

    public boolean rCompare5(String type, Object value, Object valueTo) {
        logger.debug("\u6267\u884c\u4e0d\u7b49\u4e8e\u6761\u4ef6,\u57fa\u51c6\u503c:{},\u6bd4\u8f83\u503c:{}", value, valueTo);
        if (valueTo == null && value == null) {
            return false;
        }
        if (valueTo == null || value == null) {
            return true;
        }
        if ("1".equals(type)) {
            return !value.equals(valueTo);
        }
        String strTo = valueTo.toString().replace(",", "").trim();
        String str = value.toString().replace(",", "").trim();
        if (strTo.isEmpty() || str.isEmpty()) {
            return false;
        }
        if ("2".equals(type)) {
            return Double.parseDouble(strTo) != Double.parseDouble(str);
        }
        if (VALUE_TYPE_AMT.equals(type)) {
            return Double.parseDouble(strTo) != Double.parseDouble(str);
        }
        return false;
    }

    public boolean rIsEmpty(String value) {
        logger.debug("\u6267\u884c\u5224\u7a7a\u6761\u4ef6,\u503c:{}", (Object)value);
        if (value == null) {
            return true;
        }
        return value.trim().isEmpty();
    }

    public boolean rIsNotEmpty(String value) {
        logger.debug("\u6267\u884c\u5224\u975e\u7a7a\u6761\u4ef6,\u503c:{}", (Object)value);
        if (value == null) {
            return false;
        }
        return !value.trim().isEmpty();
    }

    public boolean rTotalAmt(String type, String amtSum, String accoutNo, String amt) {
        logger.debug("\u6267\u884c\u7d2f\u8ba1\u91d1\u989d\u6761\u4ef6,\u7d2f\u8ba1\u503c:{},\u5e10\u53f7:{}\uff0c\u4ea4\u6613\u91d1\u989d", new Object[]{amtSum, accoutNo, amt});
        return false;
    }

    static {
        Method[] arr;
        logger = LoggerFactory.getLogger(RuleComputer.class);
        methods = new HashMap<String, Method>();
        for (Method method : arr = RuleComputer.class.getMethods()) {
            if (!method.getName().startsWith("r")) continue;
            methods.put(method.getName(), method);
        }
    }

    class ComputeResult {
        boolean ret;
        String logicOrder;
        String logicOp;

        protected ComputeResult(boolean ret, String order, String op) {
            this.ret = ret;
            this.logicOrder = order;
            this.logicOp = op;
        }
    }
}

