/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.RuleConditionBo;
import cn.com.yusys.yusp.param.bo.RuleConditionParameterBo;
import cn.com.yusys.yusp.param.bo.RuleDefineBo;
import cn.com.yusys.yusp.param.bo.RuleEventBo;
import cn.com.yusys.yusp.param.dto.RuleConditionDto;
import cn.com.yusys.yusp.param.dto.RuleDefineEditDto;
import cn.com.yusys.yusp.param.vo.RuleDefineEditVo;
import cn.com.yusys.yusp.param.vo.RuleDefineVo;
import cn.com.yusys.yusp.rule.dao.RuleChannelMappingDao;
import cn.com.yusys.yusp.rule.dao.RuleConditionDao;
import cn.com.yusys.yusp.rule.dao.RuleConditionParameterDao;
import cn.com.yusys.yusp.rule.dao.RuleDefineDao;
import cn.com.yusys.yusp.rule.dao.RuleEventDao;
import cn.com.yusys.yusp.rule.dao.RuleOrgMappingDao;
import cn.com.yusys.yusp.rule.dao.RuleTradeMappingDao;
import cn.com.yusys.yusp.rule.domain.entity.RuleChannelMappingEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleConditionEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleConditionParameterEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleDefineEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleEventEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleOrgMappingEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleTradeMappingEntity;
import cn.com.yusys.yusp.rule.domain.query.RuleDefineQuery;
import cn.com.yusys.yusp.rule.service.RuleDefineService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleDefineServiceImpl
implements RuleDefineService {
    @Autowired
    private RuleDefineDao ruleDefineMapper;
    @Autowired
    private RuleConditionDao ruleCondMapper;
    @Autowired
    private RuleEventDao ruleEventMapper;
    @Autowired
    private RuleConditionParameterDao ruleCondParamMapper;
    @Autowired
    private RuleTradeMappingDao ruleTradeMappingMapper;
    @Autowired
    private RuleOrgMappingDao ruleOrgMappingDao;
    @Autowired
    private RuleChannelMappingDao ruleChannelMappingDao;

    private String getSeq() {
        String seqId = System.currentTimeMillis() + "";
        return seqId;
    }

    @Override
    @Transactional(rollbackFor={IcspException.class, Exception.class})
    public int create(RuleDefineEditDto ruleDefineEditDto) throws Exception {
        this.beforeCheck(ruleDefineEditDto);
        RuleDefineBo ruleDefineBo = ruleDefineEditDto.getRuleDefine();
        String ruleId = this.getSeq();
        ruleDefineBo.setRuleId(ruleId);
        ruleDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleDefineEntity ruleDefineEntity = new RuleDefineEntity();
        BeanUtils.beanCopy((Object)ruleDefineBo, (Object)ruleDefineEntity);
        this.ruleDefineMapper.insert(ruleDefineEntity);
        List ruleConditionDtos = ruleDefineEditDto.getConditions();
        RuleConditionEntity ruleConditionEntity = new RuleConditionEntity();
        for (RuleConditionDto ruleConditionDto : ruleConditionDtos) {
            RuleConditionBo ruleConditionBo = ruleConditionDto.getCondInfo();
            String condId = this.getSeq();
            ruleConditionBo.setCondId(condId);
            ruleConditionBo.setRuleId(ruleId);
            BeanUtils.beanCopy((Object)ruleConditionBo, (Object)ruleConditionEntity);
            this.ruleCondMapper.insert(ruleConditionEntity);
            List ruleConditionParameters = ruleConditionDto.getParameters();
            if (ruleConditionParameters == null || ruleConditionParameters.size() == 0) {
                if (!"2".equals(ruleConditionBo.getCompType())) continue;
                throw new IcspException("500", "\u89c4\u5219\u5b9a\u4e49\u6761\u4ef6\u4fe1\u606f\u53c2\u6570\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            RuleConditionParameterEntity ruleConditionParameterEntity = new RuleConditionParameterEntity();
            for (RuleConditionParameterBo ruleConditionParameterBo : ruleConditionParameters) {
                ruleConditionParameterBo.setCondId(condId);
                ruleConditionParameterBo.setRuleId(ruleId);
                String paramId = this.getSeq();
                ruleConditionParameterBo.setParamId(paramId);
                BeanUtils.beanCopy((Object)ruleConditionParameterBo, (Object)ruleConditionParameterEntity);
                this.ruleCondParamMapper.insert(ruleConditionParameterEntity);
            }
        }
        List ruleEvents = ruleDefineEditDto.getEvents();
        RuleEventEntity ruleEventEntity = new RuleEventEntity();
        for (Object ruleEventBo : ruleEvents) {
            String eventId = this.getSeq();
            ruleEventBo.setEventId(eventId);
            ruleEventBo.setRuleId(ruleId);
            BeanUtils.beanCopy((Object)ruleEventBo, (Object)ruleEventEntity);
            this.ruleEventMapper.insert(ruleEventEntity);
        }
        List applyTrades = ruleDefineEditDto.getRuleDefine().getApplyTrades();
        for (String tradeCode : applyTrades) {
            RuleTradeMappingEntity ruleTradeMapping = new RuleTradeMappingEntity();
            ruleTradeMapping.setRuleId(ruleId);
            ruleTradeMapping.setTradeCode(tradeCode);
            this.ruleTradeMappingMapper.insert(ruleTradeMapping);
        }
        List applyOrgs = ruleDefineEditDto.getRuleDefine().getApplyOrgs();
        ArrayList<RuleOrgMappingEntity> orgList = new ArrayList<RuleOrgMappingEntity>();
        for (String orgId : applyOrgs) {
            RuleOrgMappingEntity ruleOrgMappingEntity = new RuleOrgMappingEntity();
            ruleOrgMappingEntity.setRuleId(ruleId);
            ruleOrgMappingEntity.setOrgId(orgId);
            orgList.add(ruleOrgMappingEntity);
        }
        this.ruleOrgMappingDao.batchInsert(orgList);
        List applyChannels = ruleDefineEditDto.getRuleDefine().getApplyChannels();
        ArrayList<RuleChannelMappingEntity> channelList = new ArrayList<RuleChannelMappingEntity>();
        for (String channelCode : applyChannels) {
            RuleChannelMappingEntity ruleChannelMappingEntity = new RuleChannelMappingEntity();
            ruleChannelMappingEntity.setRuleId(ruleId);
            ruleChannelMappingEntity.setChannelCode(channelCode);
            channelList.add(ruleChannelMappingEntity);
        }
        this.ruleChannelMappingDao.batchInsert(channelList);
        return 1;
    }

    @Override
    @Transactional(rollbackFor={IcspException.class, Exception.class})
    public int update(RuleDefineEditDto ruleDefineEditDto) throws Exception {
        this.beforeCheck(ruleDefineEditDto);
        RuleDefineBo ruleDefineBo = ruleDefineEditDto.getRuleDefine();
        ruleDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleDefineEntity ruleDefineEntity = new RuleDefineEntity();
        BeanUtils.beanCopy((Object)ruleDefineBo, (Object)ruleDefineEntity);
        this.ruleDefineMapper.updateByPrimaryKey(ruleDefineEntity);
        this.ruleCondParamMapper.deleteByRuleId(ruleDefineBo.getRuleId());
        this.ruleCondMapper.deleteByRuleId(ruleDefineBo.getRuleId());
        this.ruleEventMapper.deleteByRuleId(ruleDefineBo.getRuleId());
        this.ruleTradeMappingMapper.deleteByRuleId(ruleDefineBo.getRuleId());
        List ruleConditionDtos = ruleDefineEditDto.getConditions();
        RuleConditionEntity ruleConditionEntity = new RuleConditionEntity();
        for (RuleConditionDto ruleConditionDto : ruleConditionDtos) {
            RuleConditionBo ruleConditionBo = ruleConditionDto.getCondInfo();
            String condId = this.getSeq();
            ruleConditionBo.setCondId(condId);
            ruleConditionBo.setRuleId(ruleDefineBo.getRuleId());
            BeanUtils.beanCopy((Object)ruleConditionBo, (Object)ruleConditionEntity);
            this.ruleCondMapper.insert(ruleConditionEntity);
            List ruleConditionParameters = ruleConditionDto.getParameters();
            if (ruleConditionParameters == null || ruleConditionParameters.size() == 0) {
                if (!"2".equals(ruleConditionBo.getCompType())) continue;
                throw new IcspException("500", "\u89c4\u5219\u5b9a\u4e49\u6761\u4ef6\u4fe1\u606f\u53c2\u6570\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            RuleConditionParameterEntity ruleConditionParameterEntity = new RuleConditionParameterEntity();
            for (RuleConditionParameterBo ruleConditionParameterBo : ruleConditionParameters) {
                ruleConditionParameterBo.setCondId(condId);
                ruleConditionParameterBo.setRuleId(ruleDefineBo.getRuleId());
                String paramId = this.getSeq();
                ruleConditionParameterBo.setParamId(paramId);
                if ("compareType".equals(ruleConditionParameterBo.getParamType()) && ruleConditionParameterBo.getParamSource() == null) {
                    ruleConditionParameterBo.setParamSource("0");
                }
                BeanUtils.beanCopy((Object)ruleConditionParameterBo, (Object)ruleConditionParameterEntity);
                this.ruleCondParamMapper.insert(ruleConditionParameterEntity);
            }
        }
        List ruleEvents = ruleDefineEditDto.getEvents();
        RuleEventEntity ruleEventEntity = new RuleEventEntity();
        for (RuleEventBo ruleEventBo : ruleEvents) {
            String eventId = this.getSeq();
            ruleEventBo.setEventId(eventId);
            ruleEventBo.setRuleId(ruleDefineBo.getRuleId());
            BeanUtils.beanCopy((Object)ruleEventBo, (Object)ruleEventEntity);
            this.ruleEventMapper.insert(ruleEventEntity);
        }
        String ruleId = ruleDefineBo.getRuleId();
        List applyTrades = ruleDefineEditDto.getRuleDefine().getApplyTrades();
        this.ruleTradeMappingMapper.deleteByRuleId(ruleId);
        for (String tradeCode : applyTrades) {
            RuleTradeMappingEntity ruleTradeMapping = new RuleTradeMappingEntity();
            ruleTradeMapping.setRuleId(ruleId);
            ruleTradeMapping.setTradeCode(tradeCode);
            this.ruleTradeMappingMapper.insert(ruleTradeMapping);
        }
        List applyOrgs = ruleDefineEditDto.getRuleDefine().getApplyOrgs();
        this.ruleOrgMappingDao.deleteByRuleId(ruleId);
        ArrayList<RuleOrgMappingEntity> orgList = new ArrayList<RuleOrgMappingEntity>();
        for (String orgId : applyOrgs) {
            RuleOrgMappingEntity ruleOrgMappingEntity = new RuleOrgMappingEntity();
            ruleOrgMappingEntity.setRuleId(ruleId);
            ruleOrgMappingEntity.setOrgId(orgId);
            orgList.add(ruleOrgMappingEntity);
        }
        if (!orgList.isEmpty()) {
            this.ruleOrgMappingDao.batchInsert(orgList);
        }
        List applyChannels = ruleDefineEditDto.getRuleDefine().getApplyChannels();
        ArrayList<RuleChannelMappingEntity> channelList = new ArrayList<RuleChannelMappingEntity>();
        this.ruleChannelMappingDao.deleteByRuleId(ruleId);
        for (String channelCode : applyChannels) {
            RuleChannelMappingEntity ruleChannelMappingEntity = new RuleChannelMappingEntity();
            ruleChannelMappingEntity.setRuleId(ruleId);
            ruleChannelMappingEntity.setChannelCode(channelCode);
            channelList.add(ruleChannelMappingEntity);
        }
        if (!channelList.isEmpty()) {
            this.ruleChannelMappingDao.batchInsert(channelList);
        }
        return 1;
    }

    private void beforeCheck(RuleDefineEditDto ruleDefineEditDto) {
        if (ruleDefineEditDto.getRuleDefine() == null) {
            throw new IcspException("500", "\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ruleDefineEditDto.getRuleDefine().getRuleName() == null) {
            throw new IcspException("500", "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ruleDefineEditDto.getRuleDefine().getIsEnable() == null) {
            throw new IcspException("500", "\u89c4\u5219\u542f\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ruleDefineEditDto.getConditions() == null || ruleDefineEditDto.getConditions().size() == 0) {
            throw new IcspException("500", "\u89c4\u5219\u5b9a\u4e49\u6761\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public int delete(String ruleId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            throw new IcspException("500", "\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.ruleCondParamMapper.deleteByRuleId(ruleId);
        this.ruleCondMapper.deleteByRuleId(ruleId);
        this.ruleEventMapper.deleteByRuleId(ruleId);
        this.ruleTradeMappingMapper.deleteByRuleId(ruleId);
        this.ruleChannelMappingDao.deleteByRuleId(ruleId);
        this.ruleOrgMappingDao.deleteByRuleId(ruleId);
        this.ruleDefineMapper.deleteByPrimaryKey(ruleId);
        return 1;
    }

    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<RuleDefineVo> list = this.ruleDefineMapper.selectByModel(model);
        for (RuleDefineVo ruleDefineVo : list) {
            String ruleId = ruleDefineVo.getRuleId();
            List<String> orgIds = this.ruleOrgMappingDao.getOrgIdsByRuleId(ruleId);
            List<String> channelCodes = this.ruleChannelMappingDao.getChannelCodesByRuleId(ruleId);
            List<Map<String, String>> tradeCodes = this.ruleTradeMappingMapper.getTradeCodesByRuleId(ruleId);
            ruleDefineVo.setApplyOrgs(orgIds);
            ruleDefineVo.setApplyChannels(channelCodes);
            ruleDefineVo.setApplyTrades(tradeCodes);
        }
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<RuleDefineVo> list(QueryModel model) throws Exception {
        List<RuleDefineVo> list = this.ruleDefineMapper.selectByModel(model);
        for (RuleDefineVo ruleDefineVo : list) {
            String ruleId = ruleDefineVo.getRuleId();
            List<String> orgIds = this.ruleOrgMappingDao.getOrgIdsByRuleId(ruleId);
            List<String> channelCodes = this.ruleChannelMappingDao.getChannelCodesByRuleId(ruleId);
            List<Map<String, String>> tradeCodes = this.ruleTradeMappingMapper.getTradeCodesByRuleId(ruleId);
            ruleDefineVo.setApplyOrgs(orgIds);
            ruleDefineVo.setApplyChannels(channelCodes);
            ruleDefineVo.setApplyTrades(tradeCodes);
        }
        return list;
    }

    @Override
    public RuleDefineEditVo show(RuleDefineQuery ruleDefineQuery) throws Exception {
        String ruleId = ruleDefineQuery.getRuleId();
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            throw new IcspException("500", "\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RuleDefineEntity ruleDefineEntity = this.ruleDefineMapper.show(ruleId);
        if (ruleDefineEntity == null) {
            throw new IcspException("500", "\u89c4\u5219\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        ArrayList<RuleConditionDto> ruleCondDtos = new ArrayList<RuleConditionDto>();
        List<RuleConditionEntity> ruleConds = this.ruleCondMapper.getRuleCondsByRuleId(ruleId);
        List ruleConditionParameterBos = new ArrayList();
        for (RuleConditionEntity ruleCond : ruleConds) {
            RuleConditionBo ruleConditionBo = new RuleConditionBo();
            List<RuleConditionParameterEntity> ruleConditionParameters = this.ruleCondParamMapper.getCondParamById(ruleId, ruleCond.getCondId());
            BeanUtils.beanCopy((Object)ruleCond, (Object)ruleConditionBo);
            ruleConditionParameterBos = (List)BeanUtils.beansCopy(ruleConditionParameters, RuleConditionParameterBo.class);
            ruleCondDtos.add(new RuleConditionDto(ruleConditionBo, ruleConditionParameterBos));
        }
        List<RuleEventEntity> events = this.ruleEventMapper.getEventsByRuleId(ruleId);
        List ruleEventBos = (List)BeanUtils.beansCopy(events, RuleEventBo.class);
        List<Map<String, String>> applyTradeCodes = this.ruleTradeMappingMapper.getTradeCodesByRuleId(ruleId);
        List<String> channelCodes = this.ruleChannelMappingDao.getChannelCodesByRuleId(ruleId);
        List<String> orgIds = this.ruleOrgMappingDao.getOrgIdsByRuleId(ruleId);
        RuleDefineVo ruleDefineVo = new RuleDefineVo();
        BeanUtils.beanCopy((Object)ruleDefineEntity, (Object)ruleDefineVo);
        ruleDefineVo.setApplyOrgs(orgIds);
        ruleDefineVo.setApplyChannels(channelCodes);
        ruleDefineVo.setApplyTrades(applyTradeCodes);
        return new RuleDefineEditVo(ruleDefineVo, ruleCondDtos, ruleEventBos);
    }
}

