/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.req.IcspSysHead;
import cn.com.yusys.yusp.common.req.IcspTradeHead;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.param.bo.RuleConditionParameterBo;
import cn.com.yusys.yusp.param.dto.MenuTradeCodeDirDto;
import cn.com.yusys.yusp.param.dto.RuleConditionDto;
import cn.com.yusys.yusp.param.dto.UniformRuleDto;
import cn.com.yusys.yusp.param.vo.RuleDefineEditVo;
import cn.com.yusys.yusp.rule.dao.RuleTradeDefineDao;
import cn.com.yusys.yusp.rule.dao.UniformRuleCommonDao;
import cn.com.yusys.yusp.rule.domain.entity.RuleDefineEntity;
import cn.com.yusys.yusp.rule.domain.entity.RuleTradeDefineEntity;
import cn.com.yusys.yusp.rule.domain.query.RuleDefineQuery;
import cn.com.yusys.yusp.rule.service.RuleDefineService;
import cn.com.yusys.yusp.rule.service.UniformRuleService;
import cn.com.yusys.yusp.rule.util.ComputerMethods;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class UniformRuleServiceImpl
implements UniformRuleService {
    private static final Logger logger = LoggerFactory.getLogger(UniformRuleServiceImpl.class);
    @Autowired
    private RuleTradeDefineDao ruleTradeDefineMapper;
    @Autowired
    private RuleDefineService ruleDefineService;
    @Autowired
    private UniformRuleCommonDao UniformRuleCommonMapper;

    @Override
    public List<MenuTradeCodeDirDto> getMenuTradeCodeDir() throws Exception {
        return this.UniformRuleCommonMapper.getMenuTradeCodeDir();
    }

    @Override
    public UniformRuleDto uniformRuleCheck(IcspRequest<Map<String, Object>> request) throws Exception {
        this.icspSysHeadCheck(request.getSysHead());
        this.icspTradeHeadCheck(request.getTradeHead());
        String tradeCode = request.getTradeHead().getTradeCode();
        RuleTradeDefineEntity ruleTradeDefine = this.ruleTradeDefineMapper.show(tradeCode);
        if (ObjectUtils.isEmpty((Object)ruleTradeDefine)) {
            logger.warn("\u4ea4\u6613\u4fe1\u606f\u83b7\u53d6\u5931\u8d25,\u4e0d\u5b58\u5728\u4ea4\u6613\u4ee3\u7801\u4e3a[ " + tradeCode + " ]\u7684\u4ea4\u6613\u4fe1\u606f!");
            return new UniformRuleDto(new ArrayList());
        }
        List<RuleDefineEntity> ruleDefines = this.ruleTradeDefineMapper.getEnableRules(tradeCode);
        if (ruleDefines == null || ruleDefines.size() == 0) {
            return new UniformRuleDto(new ArrayList());
        }
        UniformRuleDto uniformRuleDto = new UniformRuleDto(new ArrayList());
        RuleDefineQuery ruleDefineQuery = new RuleDefineQuery();
        for (RuleDefineEntity ruleDefine : ruleDefines) {
            ruleDefineQuery.setRuleId(ruleDefine.getRuleId());
            RuleDefineEditVo ruleDefineEditVo = this.ruleDefineService.show(ruleDefineQuery);
            boolean isCondSuccess = false;
            Map<String, Object> head = new HashMap<String, Object>();
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = "";
            try {
                jsonString = objectMapper.writeValueAsString((Object)request.getTradeHead());
                head = (Map)objectMapper.readValue(jsonString, Map.class);
            }
            catch (JsonProcessingException e) {
                logger.debug("objectToJsonString failed!");
            }
            if (!(isCondSuccess = this.execCond(ruleDefineEditVo.getConditions(), head, (Map)request.getBody()))) continue;
            uniformRuleDto.getEvents().addAll(ruleDefineEditVo.getEvents());
        }
        return uniformRuleDto;
    }

    private void checkAuthEvent(UniformRuleDto uniformRuleDto, String tradeCode, String orgId) {
        List eventList = uniformRuleDto.getEvents();
        if (eventList == null || eventList.isEmpty()) {
            return;
        }
    }

    private void icspSysHeadCheck(IcspSysHead sysHead) {
        if (ObjectUtils.isEmpty((Object)sysHead)) {
            throw new IcspException("500", "\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u975e\u6cd5,\u7cfb\u7edf\u62a5\u6587\u5934[ sysHead ]\u4e3a\u7a7a!");
        }
    }

    private void icspTradeHeadCheck(IcspTradeHead tradeHead) {
        if (ObjectUtils.isEmpty((Object)tradeHead)) {
            throw new IcspException("500", "\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u975e\u6cd5,\u4ea4\u6613\u62a5\u6587\u5934[ tradeHead ]\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)tradeHead.getTradeCode())) {
            throw new IcspException("500", "\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u975e\u6cd5,\u4ea4\u6613\u62a5\u6587\u5934\u4e2d\u5b57\u6bb5[ tradeCode ]\u4e3a\u7a7a!");
        }
    }

    private boolean execCond(List<RuleConditionDto> ruleConds, Map<String, Object> tradeHead, Map<String, Object> body) throws Exception {
        Stack<Boolean> stack = new Stack<Boolean>();
        for (RuleConditionDto ruleCondDto : ruleConds) {
            String compClsName = ruleCondDto.getCondInfo().getCompCls();
            String compType = ruleCondDto.getCondInfo().getCompType();
            if ("must".equalsIgnoreCase(compClsName)) {
                return true;
            }
            if ("1".equals(compType) || "3".equals(compType)) {
                this.specialSymbolInStack(stack, compClsName);
                continue;
            }
            String fileName = ((RuleConditionParameterBo)ruleCondDto.getParameters().get(2)).getParamPath();
            String paramSource = ((RuleConditionParameterBo)ruleCondDto.getParameters().get(2)).getParamSource();
            String innerParamsValue = null;
            innerParamsValue = "2".equals(paramSource) ? (String)tradeHead.get(fileName) : (String)body.get(fileName);
            String paramSource1 = ((RuleConditionParameterBo)ruleCondDto.getParameters().get(1)).getParamSource();
            String paramsValue = ((RuleConditionParameterBo)ruleCondDto.getParameters().get(1)).getParamPath();
            if ("2".equals(paramSource1)) {
                paramsValue = (String)tradeHead.get(paramsValue);
            } else if ("3".equals(paramSource1)) {
                paramsValue = (String)body.get(paramsValue);
            }
            boolean checked = this.computerCondition(compClsName, ((RuleConditionParameterBo)ruleCondDto.getParameters().get(0)).getParamPath(), paramsValue, innerParamsValue);
            stack.push(checked);
        }
        Boolean result = this.computerStacksResult(stack);
        logger.info(stack.toString());
        return result;
    }

    @Override
    public void specialSymbolInStack(Stack stacks, String compClsName) throws Exception {
        if ("right".equalsIgnoreCase(compClsName)) {
            boolean result = this.computerStacksResult(stacks);
            stacks.push(result);
        } else {
            stacks.push(compClsName);
        }
    }

    @Override
    public boolean computerStacksResult(Stack stacks) throws Exception {
        Boolean result = null;
        Object stack = stacks.pop();
        String nextSymbolType = null;
        boolean isDoNext = true;
        while (isDoNext) {
            if (stack instanceof String && ("and".equalsIgnoreCase((String)stack) || "or".equalsIgnoreCase((String)stack))) {
                nextSymbolType = (String)stack;
            }
            if (stack instanceof Boolean) {
                if (result == null) {
                    result = (boolean)((Boolean)stack);
                } else {
                    if ("and".equalsIgnoreCase(nextSymbolType)) {
                        result = result != false && (Boolean)stack != false;
                        nextSymbolType = null;
                    }
                    if ("or".equalsIgnoreCase(nextSymbolType)) {
                        result = result != false || (Boolean)stack != false;
                        nextSymbolType = null;
                    }
                }
            }
            isDoNext = !stacks.isEmpty() && (!((stack = stacks.pop()) instanceof String) || !"left".equalsIgnoreCase((String)stack));
        }
        return result;
    }

    @Override
    public boolean computerCondition(String compClass, String type, Object ... params) throws Exception {
        Method method = ComputerMethods.computerMethods.get(compClass);
        if (method == null) {
            logger.error("=====>> \u8c03\u7528[ {} ]\u65b9\u6cd5\u5931\u8d25,\u672a\u83b7\u53d6\u5230\u8be5\u8ba1\u7b97\u65b9\u6cd5!", (Object)compClass);
            throw new IcspException("500", "=====>> \u8c03\u7528[ {} ]\u65b9\u6cd5\u5931\u8d25,\u672a\u83b7\u53d6\u5230\u8be5\u8ba1\u7b97\u65b9\u6cd5!", compClass);
        }
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount == 0) {
            return (Boolean)method.invoke(ComputerMethods.class.newInstance(), new Object[0]);
        }
        Object[] args = new Object[methodParamsCount];
        if (methodParamsCount == 2) {
            args[0] = params[0];
            args[1] = params[1];
        }
        if (methodParamsCount == 3) {
            args[0] = type;
            args[1] = params[0];
            args[2] = params[1];
        }
        return (Boolean)method.invoke(ComputerMethods.class.newInstance(), args);
    }
}

