/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.RuleComponentDefineBo;
import cn.com.yusys.yusp.param.vo.RuleComponentDefineVo;
import cn.com.yusys.yusp.rule.dao.RuleComponentDefineDao;
import cn.com.yusys.yusp.rule.domain.entity.RuleComponentDefineEntity;
import cn.com.yusys.yusp.rule.domain.query.RuleComponentDefineQuery;
import cn.com.yusys.yusp.rule.service.RuleComponentDefineService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleComponentDefineServiceImpl
implements RuleComponentDefineService {
    private static final Logger logger = LoggerFactory.getLogger(RuleComponentDefineServiceImpl.class);
    @Autowired
    private RuleComponentDefineDao ruleComponentDefineMapper;

    @Override
    public int create(RuleComponentDefineBo ruleComponentDefineBo) throws Exception {
        this.beforeCheck(ruleComponentDefineBo, "create");
        ruleComponentDefineBo.setCompId(StringUtils.getUUID());
        ruleComponentDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleComponentDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleComponentDefineEntity ruleComponentDefineEntity = new RuleComponentDefineEntity();
        BeanUtils.beanCopy((Object)ruleComponentDefineBo, (Object)ruleComponentDefineEntity);
        return this.ruleComponentDefineMapper.insert(ruleComponentDefineEntity);
    }

    @Override
    public int update(RuleComponentDefineBo ruleComponentDefineBo) throws Exception {
        this.beforeCheck(ruleComponentDefineBo, "update");
        ruleComponentDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleComponentDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleComponentDefineEntity ruleComponentDefineEntity = new RuleComponentDefineEntity();
        BeanUtils.beanCopy((Object)ruleComponentDefineBo, (Object)ruleComponentDefineEntity);
        return this.ruleComponentDefineMapper.updateByPrimaryKey(ruleComponentDefineEntity);
    }

    private void beforeCheck(RuleComponentDefineBo ruleComponentDefineBo, String operType) {
        if (ruleComponentDefineBo == null) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ("update".equals(operType) && StringUtil.isEmpty((String)ruleComponentDefineBo.getCompId())) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtil.isEmpty((String)ruleComponentDefineBo.getCompName())) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtil.isEmpty((String)ruleComponentDefineBo.getCompType())) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtil.isEmpty((String)ruleComponentDefineBo.getCompCls())) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public int delete(String compId) throws Exception {
        if (StringUtil.isEmpty((String)compId)) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.ruleComponentDefineMapper.deleteByPrimaryKey(compId);
    }

    @Override
    public List<RuleComponentDefineVo> index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<RuleComponentDefineEntity> list = this.ruleComponentDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleComponentDefineVo.class);
        PageHelper.clearPage();
        return voList;
    }

    @Override
    public List<RuleComponentDefineVo> list(QueryModel model) throws Exception {
        List<RuleComponentDefineEntity> list = this.ruleComponentDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleComponentDefineVo.class);
        return voList;
    }

    @Override
    public RuleComponentDefineVo show(RuleComponentDefineQuery ruleComponentDefineQuery) throws Exception {
        if (StringUtil.isEmpty((String)ruleComponentDefineQuery.getCompId())) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)ruleComponentDefineQuery);
        List<RuleComponentDefineVo> list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u89c4\u5219\u7ec4\u4ef6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!");
        }
        return list.get(0);
    }
}

