/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeBussBo;
import cn.com.yusys.yusp.operation.bo.LogTradeContentBo;
import cn.com.yusys.yusp.operation.bo.T09003000002_10_ReqBody;
import cn.com.yusys.yusp.operation.dao.LogTradeBussDao;
import cn.com.yusys.yusp.operation.dao.LogTradeDataDao;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeBussEntity;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeDataEntity;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeBussExcel;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeBussSeqExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAgentQuery;
import cn.com.yusys.yusp.operation.domain.query.LogTradeBussQuery;
import cn.com.yusys.yusp.operation.dto.MidReqLocalHead;
import cn.com.yusys.yusp.operation.service.Impl.BspFeignServiceImpl;
import cn.com.yusys.yusp.operation.service.LogTradeBussService;
import cn.com.yusys.yusp.operation.vo.LogTradeBussVo;
import cn.com.yusys.yusp.operation.vo.T09003000002_08_RespBody_STORAGE_CASH_ARRAY;
import cn.com.yusys.yusp.operation.vo.T09003000002_10_BspResp;
import cn.com.yusys.yusp.operation.vo.T09003000002_10_RespBody;
import com.github.pagehelper.PageHelper;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogTradeBussServiceImpl
implements LogTradeBussService {
    @Autowired
    private LogTradeBussDao logTradeBussMapper;
    @Autowired
    private LogTradeDataDao logTradeDataDao;
    MidReqLocalHead midReqLocalHead = new MidReqLocalHead();
    @Autowired
    BspFeignServiceImpl bspFeignService;

    @Override
    public int create(LogTradeContentBo tradeContentBo) throws Exception {
        LogTradeBussEntity logTradeBussEntity = new LogTradeBussEntity();
        cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)tradeContentBo.getTradeBussBo(), (Object)logTradeBussEntity);
        int ret1 = this.logTradeBussMapper.insert(logTradeBussEntity);
        if (tradeContentBo.getTradeDataBo() != null) {
            LogTradeDataEntity logTradeDataEntity = new LogTradeDataEntity();
            cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)tradeContentBo.getTradeDataBo(), (Object)logTradeDataEntity);
            ret1 += this.logTradeDataDao.insert(logTradeDataEntity);
        }
        return ret1;
    }

    @Override
    public int update(LogTradeContentBo logTradeContentBo) throws Exception {
        LogTradeBussEntity logTradeBussEntity = new LogTradeBussEntity();
        cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)logTradeContentBo.getTradeBussBo(), (Object)logTradeBussEntity);
        int ret1 = this.logTradeBussMapper.updateByPrimaryKey(logTradeBussEntity);
        if (logTradeContentBo.getTradeDataBo() != null) {
            LogTradeDataEntity logTradeDataEntity = new LogTradeDataEntity();
            cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)logTradeContentBo.getTradeDataBo(), (Object)logTradeDataEntity);
            ret1 += this.logTradeDataDao.updateByPrimaryKey(logTradeDataEntity);
        }
        return ret1;
    }

    @Override
    public LogTradeBussVo show(LogTradeBussQuery logTradeBussQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)logTradeBussQuery);
        List<LogTradeBussVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ globalSeq=" + logTradeBussQuery.getGlobalSeq() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=LogTradeBussVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogTradeBussEntity> list = this.logTradeBussMapper.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogTradeBussVo> list(QueryModel model) throws Exception {
        List<LogTradeBussEntity> list = this.logTradeBussMapper.selectByModel(model);
        List voList = (List)cn.com.yusys.yusp.commons.util.BeanUtils.beansCopy(list, LogTradeBussVo.class);
        return voList;
    }

    @Override
    public int delete(String globalSeq) throws Exception {
        return this.logTradeBussMapper.deleteByPrimaryKey(globalSeq);
    }

    @Override
    public List<LogTradeBussExcel> download(QueryModel model) throws Exception {
        List<LogTradeBussExcel> list = this.logTradeBussMapper.download(model);
        return list;
    }

    @Override
    public List<LogTradeBussSeqExcel> download1(QueryModel model) throws Exception {
        List<LogTradeBussSeqExcel> list = this.logTradeBussMapper.download1(model);
        return list;
    }

    @Override
    public List<LogTradeBussVo> downloadPreview(QueryModel model) {
        List<LogTradeBussEntity> list = this.logTradeBussMapper.downloadPreview(model);
        ArrayList<LogTradeBussVo> voList = new ArrayList<LogTradeBussVo>();
        for (LogTradeBussEntity entity : list) {
            if (entity == null) continue;
            LogTradeBussVo vo = new LogTradeBussVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public LogTradeBussEntity orgTradeCheck(IcspRequest<LogTradeBussQuery> request) {
        LogTradeBussQuery query = (LogTradeBussQuery)request.getBody();
        if (StringUtils.isEmpty((CharSequence)query.getOrgId())) {
            query.setOrgId(request.getTradeHead().getOrgId());
        }
        query.setWorkDate(request.getTradeHead().getWorkDate());
        QueryModel model = new QueryModel();
        model.setCondition((Object)query);
        model.setSort("serverTime desc");
        List<LogTradeBussEntity> list = this.logTradeBussMapper.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        LogTradeBussEntity entity = list.get(0);
        return entity;
    }

    @Override
    public String getT09003000002_10(IcspRequest<T09003000002_10_ReqBody> request) throws Exception {
        T09003000002_10_ReqBody reqBody = (T09003000002_10_ReqBody)request.getBody();
        if (StringUtils.isEmpty((CharSequence)reqBody.getBRANCH())) {
            reqBody.setBRANCH(request.getTradeHead().getOrgId());
        }
        BspReq bspReq2 = new BspReq();
        ReqSysHead sys_head = new ReqSysHead();
        cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)request.getSysHead(), (Object)sys_head);
        sys_head.setSYS_ENG_NAME("NCCS");
        sys_head.setSERVICE_CODE("09003000002");
        sys_head.setSERVICE_SCENE("10");
        sys_head.setAUTH_FLAG("N");
        sys_head.setUSER_ID(request.getTradeHead().getUserId());
        sys_head.setBRANCH_ID(request.getTradeHead().getOrgId());
        bspReq2.setSYS_HEAD(sys_head);
        bspReq2.setLOCAL_HEAD((Object)this.midReqLocalHead);
        bspReq2.setBODY((Object)reqBody);
        T09003000002_10_BspResp t09003000002_10_bspResp = this.bspFeignService.call(bspReq2, T09003000002_10_BspResp.class);
        T09003000002_10_RespBody t09003000002_10_respBody = t09003000002_10_bspResp.getBODY();
        T09003000002_08_RespBody_STORAGE_CASH_ARRAY storage_cash_array = (T09003000002_08_RespBody_STORAGE_CASH_ARRAY)t09003000002_10_respBody.getSTORAGE_CASH_ARRAY().get(0);
        Double d = storage_cash_array.getCASH_TOTAL_AMOUNT();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        String Amt = nf.format(d);
        return Amt;
    }

    @Override
    public String queryAgentCount4Trade(IcspRequest<LogTradeAgentQuery> request) throws Exception {
        String tradeCode = request.getTradeHead().getTradeCode();
        if (StringUtils.isEmpty((CharSequence)tradeCode)) {
            throw new IcspException("500", "\u4ea4\u6613\u7801\u672a\u4e0a\u9001\uff01");
        }
        LogTradeAgentQuery query = (LogTradeAgentQuery)request.getBody();
        String agtId = query.getAgtId();
        if (StringUtils.isEmpty((CharSequence)agtId)) {
            throw new IcspException("500", "\u4ee3\u7406\u4eba\u7f16\u53f7\u672a\u4e0a\u9001\uff01");
        }
        query.setTradeCode(tradeCode);
        List<LogTradeBussEntity> list = this.logTradeBussMapper.queryAgentCount4Trade(query);
        if (null == list) {
            return "0";
        }
        return String.valueOf(list.size());
    }

    @Override
    public int updateByGlobalSeq(LogTradeBussBo logTradeBuss) throws Exception {
        LogTradeBussEntity logTradeBussEntity = new LogTradeBussEntity();
        cn.com.yusys.yusp.commons.util.BeanUtils.beanCopy((Object)logTradeBuss, (Object)logTradeBussEntity);
        return this.logTradeBussMapper.updateByGlobalSeq(logTradeBussEntity);
    }

    @Override
    public List<LogTradeBussVo> selectByImgeNo(String imgSeq) throws Exception {
        List<LogTradeBussEntity> list = this.logTradeBussMapper.selectByImgeNo(imgSeq);
        List voList = (List)cn.com.yusys.yusp.commons.util.BeanUtils.beansCopy(list, LogTradeBussVo.class);
        return voList;
    }
}

