/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.req.IcspTradeHeadAuthUser;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeAuthBo;
import cn.com.yusys.yusp.operation.dao.LogTradeAuthDao;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeAuthEntity;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeAuthExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAuthQuery;
import cn.com.yusys.yusp.operation.service.LogTradeAuthService;
import cn.com.yusys.yusp.operation.vo.LogTradeAuthVo;
import cn.com.yusys.yusp.sequence.client.SequenceTemplateService;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogTradeAuthServiceImpl
implements LogTradeAuthService {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeAuthServiceImpl.class);
    @Autowired
    private LogTradeAuthDao logTradeAuthDao;
    @Autowired
    private SequenceTemplateService sequenceTemplateService;

    public String getAuthLogSeq() {
        String consumerSeq = StringUtils.getUUID().toLowerCase();
        try {
            consumerSeq = this.sequenceTemplateService.getSequenceTemplate("AUTH_LOG_SEQ", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return consumerSeq;
    }

    @Override
    public String create(LogTradeAuthBo logTradeAuthBo) throws Exception {
        logTradeAuthBo.setLogId(this.getAuthLogSeq());
        LogTradeAuthEntity logTradeAuthEntity = new LogTradeAuthEntity();
        BeanUtils.beanCopy((Object)logTradeAuthBo, (Object)logTradeAuthEntity);
        this.logTradeAuthDao.insert(logTradeAuthEntity);
        return logTradeAuthEntity.getLogId();
    }

    @Override
    public LogTradeAuthVo show(LogTradeAuthQuery logTradeAuthQuery) throws Exception {
        if (StringUtils.isEmpty((CharSequence)logTradeAuthQuery.getLogId())) {
            throw new IcspException("500", "\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)logTradeAuthQuery);
        List<LogTradeAuthVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ logId=" + logTradeAuthQuery.getLogId() + " ]");
        }
        return list.get(0);
    }

    @Override
    @MyPageAble(returnVo=LogTradeAuthVo.class)
    public List index(QueryModel<LogTradeAuthQuery> model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogTradeAuthEntity> list = this.logTradeAuthDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogTradeAuthVo> list(QueryModel model) throws Exception {
        List<LogTradeAuthEntity> list = this.logTradeAuthDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, LogTradeAuthVo.class);
        return listVo;
    }

    @Override
    public int update(LogTradeAuthBo logTradeAuthBo) throws Exception {
        LogTradeAuthEntity logTradeAuthEntity = new LogTradeAuthEntity();
        BeanUtils.beanCopy((Object)logTradeAuthBo, (Object)logTradeAuthEntity);
        return this.logTradeAuthDao.updateByPrimaryKey(logTradeAuthEntity);
    }

    @Override
    public int delete(String logId) throws Exception {
        return this.logTradeAuthDao.deleteByPrimaryKey(logId);
    }

    @Override
    public List<LogTradeAuthExcel> download(LogTradeAuthQuery query) {
        QueryModel model = new QueryModel();
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate("00000000");
        }
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate("99999999");
        }
        model.setCondition((Object)query);
        List<LogTradeAuthExcel> list = this.logTradeAuthDao.download(model);
        return list;
    }

    @Override
    public String saveAuthLog(IcspRequest<LogTradeAuthBo> request) throws Exception {
        LogTradeAuthBo logTradeAuthBo = new LogTradeAuthBo();
        if (null != request.getTradeHead().getAuthUserIdArray() && request.getTradeHead().getAuthUserIdArray().size() > 0 && null != request.getTradeHead().getAuthUserIdArray().get(0)) {
            logTradeAuthBo.setAuthTeller(((IcspTradeHeadAuthUser)request.getTradeHead().getAuthUserIdArray().get(0)).getAuthUserId());
            logTradeAuthBo.setAuthOrg(((IcspTradeHeadAuthUser)request.getTradeHead().getAuthUserIdArray().get(0)).getAuthOrgId());
        }
        logTradeAuthBo.setCustSeq(request.getTradeHead().getCustSerialNo());
        logTradeAuthBo.setWorkDate(request.getTradeHead().getWorkDate());
        logTradeAuthBo.setTradeCode(request.getTradeHead().getTradeCode());
        logTradeAuthBo.setTradeName(request.getTradeHead().getTradeName());
        logTradeAuthBo.setOrgId(request.getTradeHead().getOrgId());
        logTradeAuthBo.setAuthAcctSeq(request.getTradeHead().getAccountSeq());
        logTradeAuthBo.setAuthAcctNo(request.getTradeHead().getAccountNo());
        logTradeAuthBo.setAuthAmt(request.getTradeHead().getAmt());
        logTradeAuthBo.setLoginOrg(request.getTradeHead().getOrgId());
        logTradeAuthBo.setLoginTeller(request.getTradeHead().getUserId());
        logTradeAuthBo.setGlobalSeq(request.getTradeHead().getGlobalSeq());
        logTradeAuthBo.setTradeSeq(request.getTradeHead().getTradeSerialNo());
        logTradeAuthBo.setTransTellerSeq(request.getTradeHead().getTellerSerialNo());
        logTradeAuthBo.setTransTeller(request.getTradeHead().getUserId());
        logTradeAuthBo.setRemark(request.getTradeHead().getRemark());
        logTradeAuthBo.setReqChannelSeq(request.getSysHead().getChannelSeq());
        logTradeAuthBo.setAuthType("C");
        logTradeAuthBo.setReqChannel(request.getTradeHead().getChannel());
        logTradeAuthBo.setAuthRet("P");
        logTradeAuthBo.setServerDate(DateUtils.getCurrDateStr());
        logTradeAuthBo.setServerTime(DateUtils.getCurrTime());
        logTradeAuthBo.setAuthDate(request.getTradeHead().getWorkDate());
        logTradeAuthBo.setAuthDt(DateUtils.getCurrTime());
        logTradeAuthBo.setAuthSeq(this.createAuthSeq());
        logTradeAuthBo.setLogId(this.getAuthLogSeq());
        LogTradeAuthEntity logTradeAuthEntity = new LogTradeAuthEntity();
        BeanUtils.beanCopy((Object)logTradeAuthBo, (Object)logTradeAuthEntity);
        this.logTradeAuthDao.insert(logTradeAuthEntity);
        return logTradeAuthEntity.getLogId();
    }

    public String createAuthSeq() {
        String seqNo = null;
        try {
            seqNo = this.sequenceTemplateService.getSequenceTemplate("AUTH_SEQ", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String x = "";
            for (int n = 0; n < 9; ++n) {
                x = x + (int)(10.0 * Math.random());
            }
            StringBuffer authSeq = new StringBuffer();
            authSeq.append("A");
            authSeq.append(new SimpleDateFormat("yyyyMMdd").format(new Date()).toString());
            authSeq.append(x);
            seqNo = authSeq.toString();
        }
        return seqNo;
    }
}

