/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeAgentBo;
import cn.com.yusys.yusp.operation.dao.LogTradeAgentDao;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeAgentEntity;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeAgentExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAgentQuery;
import cn.com.yusys.yusp.operation.service.LogTradeAgentService;
import cn.com.yusys.yusp.operation.vo.LogTradeAgentVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogTradeAgentServiceImpl
implements LogTradeAgentService {
    @Autowired
    private LogTradeAgentDao logTradeAgentDao;

    @Override
    public int create(LogTradeAgentBo logTradeAgentBo) throws Exception {
        logTradeAgentBo.setAgtLogId(StringUtils.getUUID());
        LogTradeAgentEntity logTradeAgentEntity = new LogTradeAgentEntity();
        BeanUtils.beanCopy((Object)logTradeAgentBo, (Object)logTradeAgentEntity);
        logTradeAgentEntity.setLastChgUser(SessionUtils.getUserId());
        logTradeAgentEntity.setLastChgDt(DateUtils.formatDateTimeByDef());
        return this.logTradeAgentDao.insert(logTradeAgentEntity);
    }

    @Override
    public LogTradeAgentVo show(LogTradeAgentQuery logTradeAgentQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)logTradeAgentQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ agtLogId=" + logTradeAgentQuery.getAgtLogId() + " ]");
        }
        return (LogTradeAgentVo)list.get(0);
    }

    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogTradeAgentVo> list = this.logTradeAgentDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogTradeAgentVo> list(QueryModel model) throws Exception {
        List<LogTradeAgentVo> list = this.logTradeAgentDao.selectByModel(model);
        return list;
    }

    @Override
    public int update(LogTradeAgentBo logTradeAgentBo) throws Exception {
        LogTradeAgentEntity logTradeAgentEntity = new LogTradeAgentEntity();
        BeanUtils.beanCopy((Object)logTradeAgentBo, (Object)logTradeAgentEntity);
        logTradeAgentEntity.setLastChgUser(SessionUtils.getUserId());
        logTradeAgentEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.logTradeAgentDao.updateByPrimaryKey(logTradeAgentEntity);
    }

    @Override
    public int delete(String agtLogId) throws Exception {
        return this.logTradeAgentDao.deleteByPrimaryKey(agtLogId);
    }

    @Override
    public List<LogTradeAgentExcel> download(QueryModel model) throws Exception {
        List<LogTradeAgentExcel> list = this.logTradeAgentDao.download(model);
        return list;
    }
}

