/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.LogAgentInfoBo;
import cn.com.yusys.yusp.operation.dao.LogAgentInfoDao;
import cn.com.yusys.yusp.operation.domain.entity.LogAgentInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.LogAgentInfoQuery;
import cn.com.yusys.yusp.operation.service.LogAgentInfoService;
import cn.com.yusys.yusp.operation.vo.LogAgentInfoVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogAgentInfoServiceImpl
implements LogAgentInfoService {
    @Autowired
    private LogAgentInfoDao logAgentInfoDao;

    @Override
    public int create(LogAgentInfoBo logAgentInfoBo) throws Exception {
        LogAgentInfoEntity logAgentInfoEntity = new LogAgentInfoEntity();
        BeanUtils.beanCopy((Object)logAgentInfoBo, (Object)logAgentInfoEntity);
        logAgentInfoEntity.setAgtId(StringUtils.getUUID());
        return this.logAgentInfoDao.insert(logAgentInfoEntity);
    }

    @Override
    public LogAgentInfoVo show(LogAgentInfoQuery logAgentInfoQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)logAgentInfoQuery);
        List<LogAgentInfoVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ agtId=" + logAgentInfoQuery.getAgtId() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=LogAgentInfoVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogAgentInfoEntity> list = this.logAgentInfoDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogAgentInfoVo> list(QueryModel model) throws Exception {
        List<LogAgentInfoEntity> list = this.logAgentInfoDao.selectByModel(model);
        List logAgentInfoVos = (List)BeanUtils.beansCopy(list, LogAgentInfoVo.class);
        return logAgentInfoVos;
    }

    @Override
    public int update(LogAgentInfoBo logAgentInfoBo) throws Exception {
        LogAgentInfoEntity logAgentInfoEntity = new LogAgentInfoEntity();
        BeanUtils.beanCopy((Object)logAgentInfoBo, (Object)logAgentInfoEntity);
        return this.logAgentInfoDao.updateByPrimaryKey(logAgentInfoEntity);
    }

    @Override
    public int delete(String agtId) throws Exception {
        return this.logAgentInfoDao.deleteByPrimaryKey(agtId);
    }

    @Override
    public String saveOrUpdate(LogAgentInfoBo logAgentInfoBo) throws Exception {
        String agtCertType = logAgentInfoBo.getAgtCertType();
        String agtCertId = logAgentInfoBo.getAgtCertId();
        if (StringUtils.isEmpty((CharSequence)agtCertType) || StringUtils.isEmpty((CharSequence)agtCertId)) {
            throw new IcspException("500", "\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u5fc5\u987b\u4e0a\u4f20\uff01");
        }
        LogAgentInfoEntity logAgentInfoEntity = new LogAgentInfoEntity();
        QueryModel model = new QueryModel();
        logAgentInfoEntity.setAgtCertType(logAgentInfoBo.getAgtCertType());
        logAgentInfoEntity.setAgtCertId(logAgentInfoBo.getAgtCertId());
        model.setCondition((Object)logAgentInfoEntity);
        List<LogAgentInfoEntity> list = this.logAgentInfoDao.selectByModel(model);
        BeanUtils.beanCopy((Object)logAgentInfoBo, (Object)logAgentInfoEntity);
        if (null == list || list.size() == 0) {
            logAgentInfoEntity.setAgtId(StringUtils.getUUID());
            logAgentInfoEntity.setLastChgUser(SessionUtils.getUserId());
            logAgentInfoEntity.setLastChgDt(DateUtils.formatDateByDef());
            this.logAgentInfoDao.insert(logAgentInfoEntity);
            return logAgentInfoEntity.getAgtId();
        }
        logAgentInfoEntity.setAgtId(list.get(0).getAgtId());
        logAgentInfoEntity.setLastChgUser(SessionUtils.getUserId());
        logAgentInfoEntity.setLastChgDt(DateUtils.formatDateByDef());
        this.logAgentInfoDao.updateByPrimaryKey(logAgentInfoEntity);
        return logAgentInfoEntity.getAgtId();
    }
}

