/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.bsp.BspFeignServer;
import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.sequence.client.SequenceTemplateService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BspFeignServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(BspFeignServiceImpl.class);
    @Autowired
    BspFeignServer bspFeignServer;
    @Value(value="${esb.nccs_source_type}")
    private String nccs_source_type;
    @Autowired
    private SequenceTemplateService sequenceTemplateService;

    public BspResp call(BspReq bspReq) {
        this.packNccsHead(bspReq);
        return this.bspFeignServer.call(bspReq);
    }

    public <T> T call(BspReq bspReq, Class<T> tClass) {
        this.packNccsHead(bspReq);
        return (T)this.bspFeignServer.call(bspReq, tClass);
    }

    public void packNccsHead(BspReq bspReq) {
        String HHmmssSSS = DateUtils.formatDate((String)"HHmmssSSS");
        bspReq.getSYS_HEAD().setTRAN_TIMESTAMP(HHmmssSSS);
        String consumer_seq_no = this.createComsumerSeqNo();
        bspReq.getSYS_HEAD().setCONSUMER_SEQ_NO(consumer_seq_no);
        String global_seq_no = this.createGlobalSeqNo();
        bspReq.getSYS_HEAD().setGLOBAL_SEQ_NO(global_seq_no);
        String buss_seq_no = this.createBussSeqNo();
        bspReq.getSYS_HEAD().setBUSS_SEQ_NO(buss_seq_no);
        String seq_no = this.createSeqNo();
        bspReq.getSYS_HEAD().setORG_SYS_ID("100019");
        bspReq.getSYS_HEAD().setTRAN_MODE("ONLINE");
        bspReq.getSYS_HEAD().setSOURCE_TYPE(this.nccs_source_type);
        bspReq.getSYS_HEAD().setUSER_LANG("CHINESE");
        bspReq.getSYS_HEAD().setSYS_ENG_NAME("NCCS");
        bspReq.getSYS_HEAD().setCONSUMER_ID("100019");
        bspReq.getAPP_HEAD().setCOMPANY("QZBANK");
    }

    public String createComsumerSeqNo() {
        String consumerSeq = null;
        try {
            consumerSeq = this.sequenceTemplateService.getSequenceTemplate("CONSUMER_SEQ", null);
        }
        catch (Exception e) {
            String x = "";
            for (int n = 0; n < 9; ++n) {
                x = x + (int)(10.0 * Math.random());
                StringBuffer ComsumerSeqNo = new StringBuffer();
                ComsumerSeqNo.append("T");
                ComsumerSeqNo.append("NCCS");
                ComsumerSeqNo.append(new SimpleDateFormat("yyyyMMdd").format(new Date()).toString());
                ComsumerSeqNo.append(x);
                ComsumerSeqNo.append("00");
                consumerSeq = ComsumerSeqNo.toString();
            }
        }
        return consumerSeq;
    }

    public String createGlobalSeqNo() {
        String globalSeq = null;
        try {
            globalSeq = this.sequenceTemplateService.getSequenceTemplate("GLOBAL_SEQ", null);
        }
        catch (Exception e) {
            String x = "";
            for (int n = 0; n < 9; ++n) {
                x = x + (int)(10.0 * Math.random());
            }
            StringBuffer ComsumerSeqNo = new StringBuffer();
            ComsumerSeqNo.append("G");
            ComsumerSeqNo.append("NCCS");
            ComsumerSeqNo.append(new SimpleDateFormat("yyyyMMdd").format(new Date()).toString());
            ComsumerSeqNo.append(x);
            ComsumerSeqNo.append("00");
            globalSeq = ComsumerSeqNo.toString();
        }
        return globalSeq;
    }

    public String createSeqNo() {
        String seqNo = null;
        try {
            seqNo = this.sequenceTemplateService.getSequenceTemplate("NCCS_SEQ_NO", null);
        }
        catch (Exception e) {
            String x = "";
            for (int n = 0; n < 10; ++n) {
                x = x + (int)(10.0 * Math.random());
            }
            StringBuffer ComsumerSeqNo = new StringBuffer();
            ComsumerSeqNo.append("NCCS");
            ComsumerSeqNo.append(new SimpleDateFormat("yyyyMMdd").format(new Date()).toString());
            ComsumerSeqNo.append(x);
            seqNo = ComsumerSeqNo.toString();
        }
        return seqNo;
    }

    public String createBussSeqNo() {
        String seqNo = null;
        try {
            seqNo = this.sequenceTemplateService.getSequenceTemplate("BUSS_SEQ", null);
        }
        catch (Exception e) {
            String x = "";
            for (int n = 0; n < 10; ++n) {
                x = x + (int)(10.0 * Math.random());
            }
            StringBuffer ComsumerSeqNo = new StringBuffer();
            ComsumerSeqNo.append("B");
            ComsumerSeqNo.append("NCCS");
            ComsumerSeqNo.append(new SimpleDateFormat("yyyyMMdd").format(new Date()).toString());
            ComsumerSeqNo.append(x);
            seqNo = ComsumerSeqNo.toString();
        }
        return seqNo;
    }
}

