/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeBussBo;
import cn.com.yusys.yusp.operation.bo.LogTradeBussImgNo;
import cn.com.yusys.yusp.operation.bo.LogTradeContentBo;
import cn.com.yusys.yusp.operation.bo.T09003000002_10_ReqBody;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeBussEntity;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeBussExcel;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeBussSeqExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAgentQuery;
import cn.com.yusys.yusp.operation.domain.query.LogTradeBussQuery;
import cn.com.yusys.yusp.operation.service.LogTradeBussService;
import cn.com.yusys.yusp.operation.vo.LogTradeBussVo;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeBuss"})
public class LogTradeBussController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeBussController.class);
    @Autowired
    private LogTradeBussService logTradeBussService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogTradeContentBo> request) throws Exception {
        LogTradeContentBo tradeContentBo = (LogTradeContentBo)request.getBody();
        int result = this.logTradeBussService.create(tradeContentBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeContentBo> request) throws Exception {
        int result = this.logTradeBussService.update((LogTradeContentBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<LogTradeBussVo> show(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        LogTradeBussQuery logTradeBuss = (LogTradeBussQuery)request.getBody();
        LogTradeBussVo result = this.logTradeBussService.show(logTradeBuss);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<LogTradeBussVo>> index(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        List<LogTradeBussVo> list = this.logTradeBussService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<LogTradeBussVo>> list(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        List<LogTradeBussVo> list = this.logTradeBussService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/listByImgSeq"})
    public IcspResultDto<List<LogTradeBussVo>> listByImgSeq(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        QueryModel queryModel = new QueryModel();
        queryModel.setCondition(request.getBody());
        List<LogTradeBussVo> list = this.logTradeBussService.list(queryModel);
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        LogTradeBussBo logTradeBuss = (LogTradeBussBo)request.getBody();
        int result = this.logTradeBussService.delete(logTradeBuss.getGlobalSeq());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<LogTradeBussQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogTradeBussExcel> list = this.logTradeBussService.download(request.getQueryModel());
        File file = ExcelUtils.syncExport(LogTradeBussExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/download1"})
    @ApiOperation(value="\u8d26\u52a1\u4ea4\u6613\u6d41\u6c34\u767b\u8bb0\u7c3f\u5bfc\u51fa")
    public void download1(@RequestBody IcspRequest<LogTradeBussQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogTradeBussSeqExcel> list = this.logTradeBussService.download1(request.getQueryModel());
        File file = ExcelUtils.syncExport(LogTradeBussSeqExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/downloadPreview"})
    @ApiOperation(value="\u6253\u5370\u9884\u89c8")
    public IcspResultDto<List<LogTradeBussVo>> downloadPreview(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((LogTradeBussQuery)request.getBody()).getWorkDate())) {
            return IcspResultDto.failure((String)"500", (String)"\u7f3a\u5c11 workDate \u53c2\u6570");
        }
        List<LogTradeBussVo> list = this.logTradeBussService.downloadPreview(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/orgTradeCheck"})
    @ApiOperation(value="\u673a\u6784\u6700\u540e\u4e00\u7b14\u4ea4\u6613\u67e5\u8be2")
    public IcspResultDto<LogTradeBussEntity> orgTradeCheck(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        LogTradeBussEntity entity = this.logTradeBussService.orgTradeCheck(request);
        return IcspResultDto.success((Object)entity);
    }

    @PostMapping(value={"/getT09003000002_10"})
    @ApiOperation(value="\u673a\u6784\u5e93\u5b58\u4f59\u989d\u67e5\u8be2")
    public IcspResultDto<String> getT09003000002_10(@RequestBody IcspRequest<T09003000002_10_ReqBody> request) throws Exception {
        String Amt = this.logTradeBussService.getT09003000002_10(request);
        return IcspResultDto.success((Object)Amt);
    }

    @PostMapping(value={"/queryAgentCount4Trade"})
    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7406\u4eba\u529e\u7406\u5bf9\u5e94\u4ea4\u6613\u6b21\u6570")
    public IcspResultDto<String> queryAgentCount4Trade(@RequestBody IcspRequest<LogTradeAgentQuery> request) throws Exception {
        String agentCount = this.logTradeBussService.queryAgentCount4Trade(request);
        return IcspResultDto.success((Object)agentCount);
    }

    @PostMapping(value={"/updateByGlobalSeq"})
    public IcspResultDto<Integer> updateByGlobalSeq(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        int result = this.logTradeBussService.updateByGlobalSeq((LogTradeBussBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/selectByImgeNo"})
    public IcspResultDto<List<LogTradeBussVo>> selectByImgeNo(@RequestBody IcspRequest<LogTradeBussImgNo> request) throws Exception {
        List<LogTradeBussVo> list = this.logTradeBussService.selectByImgeNo(((LogTradeBussImgNo)request.getBody()).getImgSeq());
        return IcspResultDto.success(list, (long)list.size());
    }
}

