/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeAuthBo;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeAuthExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAuthQuery;
import cn.com.yusys.yusp.operation.service.LogTradeAuthService;
import cn.com.yusys.yusp.operation.vo.LogTradeAuthVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeAuth"})
@Api(tags={"LogTradeAuthResource"}, description="\u6388\u6743\u65e5\u5fd7\u8868")
public class LogTradeAuthController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeAuthController.class);
    @Autowired
    private LogTradeAuthService logTradeAuthService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u6388\u6743\u65e5\u5fd7\u8868")
    public IcspResultDto<String> create(@RequestBody IcspRequest<LogTradeAuthBo> request) throws Exception {
        String result = this.logTradeAuthService.create((LogTradeAuthBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u6388\u6743\u65e5\u5fd7\u8868\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<LogTradeAuthVo> show(@RequestBody IcspRequest<LogTradeAuthQuery> request) throws Exception {
        LogTradeAuthVo result = this.logTradeAuthService.show((LogTradeAuthQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u6388\u6743\u65e5\u5fd7\u8868\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeAuthVo>> index(@RequestBody IcspRequest<LogTradeAuthQuery> request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((LogTradeAuthQuery)request.getBody()).getOrgId())) {
            ((LogTradeAuthQuery)request.getBody()).setOrgId(request.getTradeHead().getOrgId());
        }
        List list = this.logTradeAuthService.index((QueryModel<LogTradeAuthQuery>)request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6388\u6743\u65e5\u5fd7\u8868\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeAuthVo>> list(@RequestBody IcspRequest<LogTradeAuthQuery> request) throws Exception {
        List<LogTradeAuthVo> list = this.logTradeAuthService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6388\u6743\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeAuthBo> request) throws Exception {
        LogTradeAuthBo logTradeAuthBo = (LogTradeAuthBo)request.getBody();
        int result = this.logTradeAuthService.update(logTradeAuthBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6388\u6743\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeAuthBo> request) throws Exception {
        LogTradeAuthBo logTradeAuthBo = (LogTradeAuthBo)request.getBody();
        int result = this.logTradeAuthService.delete(logTradeAuthBo.getLogId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<LogTradeAuthQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogTradeAuthExcel> list = this.logTradeAuthService.download((LogTradeAuthQuery)request.getBody());
        File file = ExcelUtils.syncExport(LogTradeAuthExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/saveAuthLog"})
    @ApiOperation(value="\u65b0\u589e\u6388\u6743\u65e5\u5fd7\u8868")
    public IcspResultDto<String> saveAuthLog(@RequestBody IcspRequest<LogTradeAuthBo> request) throws Exception {
        String result = this.logTradeAuthService.saveAuthLog(request);
        return IcspResultDto.success((Object)result);
    }
}

