/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeAgentBo;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeAgentExcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeAgentQuery;
import cn.com.yusys.yusp.operation.service.LogTradeAgentService;
import cn.com.yusys.yusp.operation.vo.LogTradeAgentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeAgent"})
@Api(value="\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868")
public class LogTradeAgentController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeAgentController.class);
    @Autowired
    private LogTradeAgentService logTradeAgentService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogTradeAgentBo> request) throws Exception {
        LogTradeAgentBo logTradeAgentBo = (LogTradeAgentBo)request.getBody();
        int result = this.logTradeAgentService.create(logTradeAgentBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<LogTradeAgentVo> show(@RequestBody IcspRequest<LogTradeAgentQuery> request) throws Exception {
        LogTradeAgentVo result = this.logTradeAgentService.show((LogTradeAgentQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeAgentVo>> index(@RequestBody IcspRequest<LogTradeAgentQuery> request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((LogTradeAgentQuery)request.getBody()).getOrgId())) {
            ((LogTradeAgentQuery)request.getBody()).setOrgId(request.getTradeHead().getOrgId());
        }
        List<LogTradeAgentVo> list = this.logTradeAgentService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeAgentVo>> list(@RequestBody IcspRequest<LogTradeAgentQuery> request) throws Exception {
        List<LogTradeAgentVo> list = this.logTradeAgentService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeAgentBo> request) throws Exception {
        LogTradeAgentBo logTradeAgentBo = (LogTradeAgentBo)request.getBody();
        int result = this.logTradeAgentService.update(logTradeAgentBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u4ee3\u7406\u4eba\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeAgentBo> request) throws Exception {
        LogTradeAgentBo logTradeAgentBo = (LogTradeAgentBo)request.getBody();
        int result = this.logTradeAgentService.delete(logTradeAgentBo.getAgtLogId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<LogTradeAgentQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogTradeAgentExcel> list = this.logTradeAgentService.download(request.getQueryModel());
        File file = ExcelUtils.syncExport(LogTradeAgentExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

