/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.AdminSmUserEvaluationBo;
import cn.com.yusys.yusp.operation.domain.excel.AdminSmUserEvaluationExcel;
import cn.com.yusys.yusp.operation.domain.query.AdminSmUserEvaluationQuery;
import cn.com.yusys.yusp.operation.service.AdminSmUserEvaluationService;
import cn.com.yusys.yusp.operation.vo.AdminSmUserEvaluationVo;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/adminSmUserEvaluation"})
public class AdminSmUserEvaluationController {
    private static final Logger logger = LoggerFactory.getLogger(AdminSmUserEvaluationController.class);
    @Autowired
    private AdminSmUserEvaluationService adminSmUserEvaluationService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u8bc4\u4ef7\u8868")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<AdminSmUserEvaluationBo> request) throws Exception {
        int result = this.adminSmUserEvaluationService.create((AdminSmUserEvaluationBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u4ef7\u8868\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<AdminSmUserEvaluationVo> show(@RequestBody IcspRequest<AdminSmUserEvaluationQuery> request) throws Exception {
        AdminSmUserEvaluationVo result = this.adminSmUserEvaluationService.show((AdminSmUserEvaluationQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u4ef7\u8868\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<AdminSmUserEvaluationVo>> index(@RequestBody IcspRequest<AdminSmUserEvaluationQuery> request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)((AdminSmUserEvaluationQuery)request.getBody()).getOrgId())) {
            ((AdminSmUserEvaluationQuery)request.getBody()).setOrgId(request.getTradeHead().getOrgId());
        }
        List<AdminSmUserEvaluationVo> list = this.adminSmUserEvaluationService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u4ef7\u8868\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<AdminSmUserEvaluationVo>> list(@RequestBody IcspRequest<AdminSmUserEvaluationQuery> request) throws Exception {
        List<AdminSmUserEvaluationVo> list = this.adminSmUserEvaluationService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u8bc4\u4ef7\u8868")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<AdminSmUserEvaluationBo> request) throws Exception {
        int result = this.adminSmUserEvaluationService.update((AdminSmUserEvaluationBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237\u8bc4\u4ef7\u8868")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<AdminSmUserEvaluationQuery> request) throws Exception {
        int result = this.adminSmUserEvaluationService.delete(((AdminSmUserEvaluationQuery)request.getBody()).getEvalId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<AdminSmUserEvaluationQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<AdminSmUserEvaluationExcel> list = this.adminSmUserEvaluationService.download(request.getQueryModel());
        File file = ExcelUtils.syncExport(AdminSmUserEvaluationExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

