/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.operation.dao.LogTradeUserDrawDao;
import cn.com.yusys.yusp.operation.domain.bo.LogTradeUserDrawBo;
import cn.com.yusys.yusp.operation.domain.vo.LogTradeUserDrawVo;
import cn.com.yusys.yusp.operation.service.LogTradeUserDrawService;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogTradeUserDrawServiceImpl
implements LogTradeUserDrawService {
    @Autowired
    private LogTradeUserDrawDao logTradeUserDrawDao;

    @Override
    public IcspResultDto selectUserBussTotal(LogTradeUserDrawBo logTradeUserDrawBo) {
        LogTradeUserDrawVo logTradeUserDrawVo = this.logTradeUserDrawDao.selectUserBussTotal(logTradeUserDrawBo);
        LogTradeUserDrawVo logTradeUserDrawVo1 = this.logTradeUserDrawDao.selectUserBussTotalPreMonth(logTradeUserDrawBo);
        HashMap<String, LogTradeUserDrawVo> resultMap = new HashMap<String, LogTradeUserDrawVo>();
        resultMap.put("nowMonth", logTradeUserDrawVo);
        resultMap.put("preMonth", logTradeUserDrawVo1);
        return IcspResultDto.success(resultMap);
    }

    @Override
    public IcspResultDto selectUserMonthRanking(LogTradeUserDrawBo logTradeUserDrawBo) {
        List<LogTradeUserDrawVo> logTradeUserDrawVos = this.logTradeUserDrawDao.selectUserMonthRanking(logTradeUserDrawBo);
        return IcspResultDto.success(logTradeUserDrawVos);
    }

    @Override
    public IcspResultDto selectUserAmount(LogTradeUserDrawBo logTradeUserDrawBo) {
        LogTradeUserDrawVo logTradeUserDrawVo = this.logTradeUserDrawDao.selectUserAmount(logTradeUserDrawBo);
        return IcspResultDto.success((Object)logTradeUserDrawVo);
    }

    @Override
    public IcspResultDto selectUserTime(LogTradeUserDrawBo logTradeUserDrawBo) {
        LogTradeUserDrawVo logTradeUserDrawVo = this.logTradeUserDrawDao.selectUserTime(logTradeUserDrawBo);
        return IcspResultDto.success((Object)logTradeUserDrawVo);
    }

    @Override
    public IcspResultDto selectUserBussAnaly(LogTradeUserDrawBo logTradeUserDrawBo) {
        List<LogTradeUserDrawVo> logTradeUserDrawVos = this.logTradeUserDrawDao.selectUserBussAnaly(logTradeUserDrawBo);
        return IcspResultDto.success(logTradeUserDrawVos);
    }

    @Override
    public IcspResultDto selectUserTimeAndAvg(LogTradeUserDrawBo logTradeUserDrawBo) {
        LogTradeUserDrawVo logTradeUserDrawVo = this.logTradeUserDrawDao.selectUserTimeAndAvg(logTradeUserDrawBo);
        return IcspResultDto.success((Object)logTradeUserDrawVo);
    }

    @Override
    public IcspResultDto selectUserBussTimePart(LogTradeUserDrawBo logTradeUserDrawBo) {
        List<Map<String, Object>> list = this.logTradeUserDrawDao.selectUserBussTimePart(logTradeUserDrawBo);
        BigDecimal leaveCount = BigDecimal.ZERO;
        BigDecimal freeCount = BigDecimal.ZERO;
        BigDecimal tradeCount = BigDecimal.ZERO;
        for (Map<String, Object> map : list) {
            String flag;
            switch (flag = (String)map.get("flag")) {
                case "0": {
                    leaveCount = leaveCount.add(new BigDecimal("1"));
                    break;
                }
                case "1": {
                    freeCount = freeCount.add(new BigDecimal("1"));
                    break;
                }
                case "2": {
                    tradeCount = tradeCount.add(new BigDecimal("1"));
                }
            }
        }
        String leaveRate = leaveCount.divide(new BigDecimal("54"), 4, 4).multiply(new BigDecimal("100")).setScale(2, 4) + "%";
        String freeRate = freeCount.divide(new BigDecimal("54"), 4, 4).multiply(new BigDecimal("100")).setScale(2, 4) + "%";
        String tradeRate = tradeCount.divide(new BigDecimal("54"), 4, 4).multiply(new BigDecimal("100")).setScale(2, 4) + "%";
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("list", list);
        returnMap.put("leaveRate", leaveRate);
        returnMap.put("freeRate", freeRate);
        returnMap.put("tradeRate", tradeRate);
        return IcspResultDto.success(returnMap);
    }

    @Override
    public IcspResultDto selectUserBussTable(IcspRequest<LogTradeUserDrawBo> request) {
        QueryModel queryModel = request.getQueryModel();
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<LogTradeUserDrawVo> logTradeUserDrawVos = this.logTradeUserDrawDao.selectUserBussTable((LogTradeUserDrawBo)request.getBody());
        PageHelper.clearPage();
        return IcspResultDto.success(logTradeUserDrawVos);
    }

    @Override
    public IcspResultDto selectAllBussUserRank(LogTradeUserDrawBo logTradeUserDrawBo) {
        LogTradeUserDrawVo logTradeUserDrawVo = this.logTradeUserDrawDao.selectAllBussUserRank(logTradeUserDrawBo);
        return IcspResultDto.success((Object)logTradeUserDrawVo);
    }

    @Override
    public IcspResultDto selectUserScore(LogTradeUserDrawBo logTradeUserDrawBo) {
        List<LogTradeUserDrawVo> logTradeUserDrawVos = this.logTradeUserDrawDao.selectUserScore(logTradeUserDrawBo);
        return IcspResultDto.success(logTradeUserDrawVos);
    }
}

