/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeVerfiyBo;
import cn.com.yusys.yusp.operation.domain.excel.LogTradeVerfiyEXcel;
import cn.com.yusys.yusp.operation.domain.query.LogTradeVerfiyQuery;
import cn.com.yusys.yusp.operation.service.LogTradeVerfiyService;
import cn.com.yusys.yusp.operation.vo.LogTradeVerfiyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeVerfiy"})
@Api(tags={"LogTradeVerfiyController"}, description="\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868")
public class LogTradeVerfiyController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeVerfiyController.class);
    @Autowired
    private LogTradeVerfiyService logTradeVerfiyService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogTradeVerfiyBo> request) throws Exception {
        LogTradeVerfiyBo logTradeVerfiy = (LogTradeVerfiyBo)request.getBody();
        int result = this.logTradeVerfiyService.create(logTradeVerfiy);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<LogTradeVerfiyVo> show(@RequestBody IcspRequest<LogTradeVerfiyQuery> request) throws Exception {
        LogTradeVerfiyQuery logTradeVerfiy = (LogTradeVerfiyQuery)request.getBody();
        LogTradeVerfiyVo result = this.logTradeVerfiyService.show(logTradeVerfiy);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeVerfiyVo>> index(@RequestBody IcspRequest<LogTradeVerfiyQuery> request) throws Exception {
        List list = this.logTradeVerfiyService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<LogTradeVerfiyVo>> list(@RequestBody IcspRequest<LogTradeVerfiyQuery> request) throws Exception {
        List<LogTradeVerfiyVo> list = this.logTradeVerfiyService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeVerfiyBo> request) throws Exception {
        LogTradeVerfiyBo logTradeVerfiy = (LogTradeVerfiyBo)request.getBody();
        int result = this.logTradeVerfiyService.update(logTradeVerfiy);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u8054\u7f51\u6838\u67e5\u65e5\u5fd7\u8868")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeVerfiyBo> request) throws Exception {
        LogTradeVerfiyBo logTradeVerfiy = (LogTradeVerfiyBo)request.getBody();
        int result = this.logTradeVerfiyService.delete(logTradeVerfiy.getLogId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<LogTradeVerfiyQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogTradeVerfiyEXcel> list = this.logTradeVerfiyService.download(request.getQueryModel());
        File file = ExcelUtils.syncExport(LogTradeVerfiyEXcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

