/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.operation.bo.LogAdminSmBo;
import cn.com.yusys.yusp.operation.domain.excel.LogAdminSmExcel;
import cn.com.yusys.yusp.operation.domain.query.LogAdminSmQuery;
import cn.com.yusys.yusp.operation.service.LogAdminSmService;
import cn.com.yusys.yusp.operation.vo.LogAdminSmVo;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logAdminSm"})
public class LogAdminSmController {
    private static final Logger logger = LoggerFactory.getLogger(LogAdminSmController.class);
    @Autowired
    private LogAdminSmService logAdminSmService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogAdminSmBo> request, HttpServletRequest httpServletRequest) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        return IcspResultDto.success((Object)0);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<LogAdminSmVo> show(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        LogAdminSmQuery logAdminSm = (LogAdminSmQuery)request.getBody();
        LogAdminSmVo result = this.logAdminSmService.show(logAdminSm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<LogAdminSmVo>> index(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        List<LogAdminSmVo> list = this.logAdminSmService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/queryLastInfo"})
    public IcspResultDto<List<LogAdminSmVo>> queryLastInfo(@RequestBody IcspRequest<LogAdminSmBo> request) throws Exception {
        List<LogAdminSmVo> list = this.logAdminSmService.queryLastInfo(((LogAdminSmBo)request.getBody()).getUserId());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<LogAdminSmVo>> list(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        List<LogAdminSmVo> list = this.logAdminSmService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogAdminSmBo> request) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        int result = this.logAdminSmService.update(logAdminSm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogAdminSmBo> request) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        int result = this.logAdminSmService.delete(logAdminSm.getLogId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<LogAdminSmQuery> icspRequest, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<LogAdminSmExcel> list = this.logAdminSmService.download(icspRequest.getQueryModel());
        File file = ExcelUtils.syncExport(LogAdminSmExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

