/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.util.IcspSessionUtils;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.LogAdminSmBo;
import cn.com.yusys.yusp.operation.dao.LogAdminSmDao;
import cn.com.yusys.yusp.operation.domain.entity.LogAdminSmEntity;
import cn.com.yusys.yusp.operation.domain.query.LogAdminSmQuery;
import cn.com.yusys.yusp.operation.service.LogAdminSmService;
import cn.com.yusys.yusp.operation.vo.LogAdminSmVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogAdminSmServiceImpl
implements LogAdminSmService {
    @Autowired
    private LogAdminSmDao logAdminSmMapper;

    @Override
    public int create(LogAdminSmBo logAdminSm) throws Exception {
        LogAdminSmEntity logAdminSmEntity = new LogAdminSmEntity();
        BeanUtils.beanCopy((Object)logAdminSm, (Object)logAdminSmEntity);
        logAdminSmEntity.setLogId(StringUtils.getUUID());
        logAdminSmEntity.setUserId(SessionUtils.getUserId());
        logAdminSmEntity.setOperTime(DateUtils.formatDateTimeByDef());
        logAdminSmEntity.setOrgId(IcspSessionUtils.getCurrentOrgId());
        return this.logAdminSmMapper.insert(logAdminSmEntity);
    }

    @Override
    public LogAdminSmVo show(LogAdminSmQuery logAdminSmQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)logAdminSmQuery);
        List<LogAdminSmVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ logId=" + logAdminSmQuery.getLogId() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=LogAdminSmVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogAdminSmEntity> list = this.logAdminSmMapper.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogAdminSmVo> list(QueryModel model) throws Exception {
        List<LogAdminSmEntity> list = this.logAdminSmMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, LogAdminSmVo.class);
        return voList;
    }

    @Override
    public int update(LogAdminSmBo logAdminSm) throws Exception {
        LogAdminSmEntity logAdminSmEntity = new LogAdminSmEntity();
        BeanUtils.beanCopy((Object)logAdminSm, (Object)logAdminSmEntity);
        return this.logAdminSmMapper.updateByPrimaryKey(logAdminSmEntity);
    }

    @Override
    public int delete(String logId) throws Exception {
        return this.logAdminSmMapper.deleteByPrimaryKey(logId);
    }

    @Override
    public void download(QueryModel model, HttpServletResponse response) throws Exception {
        List<LogAdminSmEntity> list = this.logAdminSmMapper.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        int totalRowNum = 0;
        int sheetNum = 1;
        int sheetSize = 20000;
        do {
            HSSFSheet sheet = this.createSheet(wk, sheetNum);
            int rowNum = 0;
            for (int i = totalRowNum; i < list.size(); ++i) {
                LogAdminSmEntity logAdminSmEntity = list.get(i);
                HSSFRow row = sheet.createRow(++rowNum);
                Cell cUserId = row.createCell(0);
                cUserId.setCellValue(logAdminSmEntity.getUserId());
                Cell cOperTime = row.createCell(1);
                cOperTime.setCellValue(logAdminSmEntity.getOperTime());
                Cell cOperObjId = row.createCell(2);
                cOperObjId.setCellValue(logAdminSmEntity.getOperObjId());
                Cell cOperFlag = row.createCell(3);
                cOperFlag.setCellValue(logAdminSmEntity.getOperFlag());
                Cell cLogTypeId = row.createCell(4);
                cLogTypeId.setCellValue(logAdminSmEntity.getLogTypeId());
                Cell cContent = row.createCell(5);
                cContent.setCellValue(logAdminSmEntity.getContent());
                Cell cOrgId = row.createCell(6);
                cOrgId.setCellValue(logAdminSmEntity.getOrgId());
                Cell cLoginIp = row.createCell(7);
                cLoginIp.setCellValue(logAdminSmEntity.getLoginIp());
                if (++totalRowNum % sheetSize == 0) break;
            }
            ++sheetNum;
        } while (totalRowNum != list.size());
        String date = DateUtils.formatDate((String)"yyyyMMddHHmmss");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"UserOperLog_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    public HSSFSheet createSheet(HSSFWorkbook wk, int sheetNum) {
        HSSFSheet sheet = wk.createSheet("sheet" + sheetNum);
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cUserIdTitle = rowTitle.createCell(0);
        cUserIdTitle.setCellValue("\u7528\u6237\u7f16\u53f7");
        Cell cOperTimeTitle = rowTitle.createCell(1);
        cOperTimeTitle.setCellValue("\u64cd\u4f5c\u65f6\u95f4");
        Cell cOperObjIdTitle = rowTitle.createCell(2);
        cOperObjIdTitle.setCellValue("\u64cd\u4f5c\u5bf9\u8c61\u7f16\u53f7");
        Cell cOperFlagTitle = rowTitle.createCell(3);
        cOperFlagTitle.setCellValue("\u64cd\u4f5c\u6807\u5fd7");
        Cell cLogTypeIdTitle = rowTitle.createCell(4);
        cLogTypeIdTitle.setCellValue("\u65e5\u5fd7\u7c7b\u578b");
        Cell cContentTitle = rowTitle.createCell(5);
        cContentTitle.setCellValue("\u65e5\u5fd7\u5185\u5bb9");
        Cell cOrgIdTitle = rowTitle.createCell(6);
        cOrgIdTitle.setCellValue("\u64cd\u4f5c\u8005\u673a\u6784");
        Cell cLoginIpTitle = rowTitle.createCell(7);
        cLoginIpTitle.setCellValue("\u767b\u5f55IP");
        return sheet;
    }
}

