/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.operation.bo.LogTradeBussBo;
import cn.com.yusys.yusp.operation.domain.query.LogTradeBussQuery;
import cn.com.yusys.yusp.operation.service.LogTradeBussService;
import cn.com.yusys.yusp.operation.vo.LogTradeBussVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeBuss"})
public class LogTradeBussController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeBussController.class);
    @Autowired
    private LogTradeBussService logTradeBussService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        LogTradeBussBo logTradeBuss = (LogTradeBussBo)request.getBody();
        int result = this.logTradeBussService.create(logTradeBuss);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<LogTradeBussVo> show(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        LogTradeBussQuery logTradeBuss = (LogTradeBussQuery)request.getBody();
        LogTradeBussVo result = this.logTradeBussService.show(logTradeBuss);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<LogTradeBussVo>> index(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        List<LogTradeBussVo> list = this.logTradeBussService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<LogTradeBussVo>> list(@RequestBody IcspRequest<LogTradeBussQuery> request) throws Exception {
        List<LogTradeBussVo> list = this.logTradeBussService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        LogTradeBussBo logTradeBuss = (LogTradeBussBo)request.getBody();
        int result = this.logTradeBussService.update(logTradeBuss);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeBussBo> request) throws Exception {
        LogTradeBussBo logTradeBuss = (LogTradeBussBo)request.getBody();
        int result = this.logTradeBussService.delete(logTradeBuss.getLogId());
        return IcspResultDto.success((Object)result);
    }
}

