/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.operation.bo.LogTradeCommBo;
import cn.com.yusys.yusp.operation.domain.query.LogTradeCommQuery;
import cn.com.yusys.yusp.operation.service.LogTradeCommService;
import cn.com.yusys.yusp.operation.vo.LogTradeCommVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logTradeComm"})
public class LogTradeCommController {
    private static final Logger logger = LoggerFactory.getLogger(LogTradeCommController.class);
    @Autowired
    private LogTradeCommService logTradeCommService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogTradeCommBo> request) throws Exception {
        LogTradeCommBo logTradeComm = (LogTradeCommBo)request.getBody();
        int result = this.logTradeCommService.create(logTradeComm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<LogTradeCommVo> show(@RequestBody IcspRequest<LogTradeCommQuery> request) throws Exception {
        LogTradeCommQuery logTradeComm = (LogTradeCommQuery)request.getBody();
        LogTradeCommVo result = this.logTradeCommService.show(logTradeComm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<LogTradeCommVo>> index(@RequestBody IcspRequest<LogTradeCommQuery> request) throws Exception {
        List<LogTradeCommVo> list = this.logTradeCommService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<LogTradeCommVo>> list(@RequestBody IcspRequest<LogTradeCommQuery> request) throws Exception {
        List<LogTradeCommVo> list = this.logTradeCommService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogTradeCommBo> request) throws Exception {
        LogTradeCommBo logTradeComm = (LogTradeCommBo)request.getBody();
        int result = this.logTradeCommService.update(logTradeComm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogTradeCommBo> request) throws Exception {
        LogTradeCommBo logTradeComm = (LogTradeCommBo)request.getBody();
        int result = this.logTradeCommService.delete(logTradeComm.getLogId());
        return IcspResultDto.success((Object)result);
    }
}

