/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.dao.OperSealHandoverDao;
import cn.com.yusys.yusp.operation.dao.OperSealInfoDao;
import cn.com.yusys.yusp.operation.domain.dto.SealDestroyDto;
import cn.com.yusys.yusp.operation.domain.dto.SealDto;
import cn.com.yusys.yusp.operation.domain.dto.SealHandoverDto;
import cn.com.yusys.yusp.operation.domain.dto.SealPutDto;
import cn.com.yusys.yusp.operation.domain.entity.OperSealHandoverEntity;
import cn.com.yusys.yusp.operation.domain.entity.OperSealInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.OperSealHandoverQuery;
import cn.com.yusys.yusp.operation.service.OperSealHandoverService;
import cn.com.yusys.yusp.operation.vo.OperSealHandoverVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperSealHandoverServiceImpl
implements OperSealHandoverService {
    private static final Logger logger = LoggerFactory.getLogger(OperSealHandoverServiceImpl.class);
    @Autowired
    private OperSealHandoverDao operSealHandoverDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean create(IcspRequest<SealPutDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperSealInfoDao operSealInfoDao = (OperSealInfoDao)session.getMapper(OperSealInfoDao.class);
        boolean flag = false;
        SealPutDto sealPutDto = (SealPutDto)request.getBody();
        try {
            OperSealHandoverEntity sealHandoverEntity = new OperSealHandoverEntity();
            sealHandoverEntity.setHandoverType(sealPutDto.getHandoverType());
            sealHandoverEntity.setRemark(sealPutDto.getRemark());
            sealHandoverEntity.setReciveUser(sealPutDto.getPutUser());
            sealHandoverEntity.setCurrentOrgId(sealPutDto.getPutOrgId());
            sealHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            sealHandoverEntity.setHandoverTime(DateUtils.formatDate((String)"HHmmssSSS"));
            sealHandoverEntity.setReciveAdminUser(sealPutDto.getTogethrtAdminUser());
            sealHandoverEntity.setSealNo(sealPutDto.getSealNo());
            sealHandoverEntity.setLogType("1");
            sealHandoverEntity.setHandoverId(StringUtils.getUUID());
            sealHandoverEntity.setLastChangeUser(SessionUtils.getUserId());
            sealHandoverEntity.setLastChangeDate(DateUtils.formatDateTimeByDef());
            this.operSealHandoverDao.insert(sealHandoverEntity);
            OperSealInfoEntity sealInfoEntity = new OperSealInfoEntity();
            sealInfoEntity.setSealNo(sealPutDto.getSealNo());
            QueryModel model = new QueryModel();
            model.setCondition((Object)sealInfoEntity);
            List<OperSealInfoEntity> operSealInfoEntities = operSealInfoDao.selectByModel(model);
            if (operSealInfoEntities.size() != 0) {
                throw new IcspException("500", "\u8be5\u5370\u7ae0\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            sealInfoEntity.setSealId(StringUtils.getUUID());
            sealInfoEntity.setCurrentOrgId(sealPutDto.getPutOrgId());
            sealInfoEntity.setSealState(sealPutDto.getHandoverType());
            sealInfoEntity.setSealName(sealPutDto.getSealName());
            sealInfoEntity.setRemark(sealPutDto.getRemark());
            sealInfoEntity.setPutUser(sealPutDto.getPutUser());
            sealInfoEntity.setTogethrtAdminUser(sealPutDto.getTogethrtAdminUser());
            sealInfoEntity.setPutDate(request.getTradeHead().getWorkDate());
            sealInfoEntity.setPutTime(DateUtils.formatDate((String)"HHmmssSSS"));
            sealInfoEntity.setPutOrgId(sealPutDto.getPutOrgId());
            sealInfoEntity.setLastChangeUser(SessionUtils.getUserId());
            sealInfoEntity.setLastChangeDate(DateUtils.formatDateTimeByDef());
            operSealInfoDao.insert(sealInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public OperSealHandoverVo show(OperSealHandoverQuery operSealHandoverQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operSealHandoverQuery);
        List<OperSealHandoverEntity> operSealHandoverEntities = this.operSealHandoverDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(operSealHandoverEntities, OperSealHandoverVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ handoverId=" + operSealHandoverQuery.getHandoverId() + " ]");
        }
        return (OperSealHandoverVo)list.get(0);
    }

    @MyPageAble(returnVo=SealDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<SealDto> list = this.operSealHandoverDao.selectDtoByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<OperSealHandoverVo> list(QueryModel model) throws Exception {
        List<OperSealHandoverEntity> list = this.operSealHandoverDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, OperSealHandoverVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(IcspRequest<SealHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperSealInfoDao operSealInfoDao = (OperSealInfoDao)session.getMapper(OperSealInfoDao.class);
        boolean flag = false;
        SealHandoverDto sealHandoverDto = (SealHandoverDto)request.getBody();
        try {
            OperSealHandoverEntity sealHandoverEntity = new OperSealHandoverEntity();
            sealHandoverEntity.setSealNo(sealHandoverDto.getSealNo());
            QueryModel model = new QueryModel();
            model.setCondition((Object)sealHandoverEntity);
            List<OperSealHandoverEntity> operSealHandoverEntities = this.operSealHandoverDao.selectByModel(model);
            for (OperSealHandoverEntity operSealHandoverEntity : operSealHandoverEntities) {
                operSealHandoverEntity.setLogType("2");
                this.operSealHandoverDao.updateByPrimaryKey(operSealHandoverEntity);
            }
            BeanUtils.beanCopy((Object)sealHandoverDto, (Object)sealHandoverEntity);
            sealHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            sealHandoverEntity.setHandoverTime(DateUtils.formatDate((String)"HH:mm:ss"));
            sealHandoverEntity.setHandoverId(StringUtils.getUUID());
            sealHandoverEntity.setLastChangeUser(SessionUtils.getUserId());
            sealHandoverEntity.setLastChangeDate(DateUtils.formatDateTimeByDef());
            sealHandoverEntity.setLogType("1");
            this.operSealHandoverDao.insert(sealHandoverEntity);
            OperSealInfoEntity entity = new OperSealInfoEntity();
            entity.setSealId(sealHandoverDto.getSealId());
            entity.setSealNo(sealHandoverDto.getSealNo());
            entity.setCurrentOrgId(sealHandoverDto.getCurrentOrgId());
            entity.setSealName(sealHandoverDto.getSealName());
            entity.setSealState(sealHandoverDto.getHandoverType());
            entity.setRemark(sealHandoverDto.getRemark());
            entity.setSrcOrgId(sealHandoverDto.getSrcOrgId());
            entity.setReciveUser(sealHandoverDto.getReciveUser());
            entity.setReciveAdminUser(sealHandoverDto.getReciveAdminUser());
            entity.setHandoverSupervisor(sealHandoverDto.getHandoverSupervisor());
            entity.setLastChangeUser(SessionUtils.getUserId());
            entity.setLastChangeDate(DateUtils.formatDateTimeByDef());
            operSealInfoDao.updateByPrimaryKey(entity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(IcspRequest<SealDestroyDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperSealInfoDao operSealInfoDao = (OperSealInfoDao)session.getMapper(OperSealInfoDao.class);
        boolean flag = false;
        SealDestroyDto sealDestroyDto = (SealDestroyDto)request.getBody();
        try {
            OperSealHandoverEntity sealHandoverEntity = new OperSealHandoverEntity();
            if ("4".equals(sealDestroyDto.getHandoverType())) {
                sealHandoverEntity.setSealNo(sealDestroyDto.getSealNo());
                sealHandoverEntity.setHandoverType("1");
                sealHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
                QueryModel model = new QueryModel();
                model.setCondition((Object)sealHandoverEntity);
                List<OperSealHandoverEntity> operSealHandoverEntities = this.operSealHandoverDao.selectByModel(model);
                if (operSealHandoverEntities.size() == 0) {
                    throw new IcspException("500", "\u53ea\u5141\u8bb8\u6ce8\u9500\u5f53\u65e5\u5165\u5e93\u7684\u5370\u7ae0");
                }
                if (operSealHandoverEntities.size() == 1) {
                    this.operSealHandoverDao.deleteBySealNo(sealDestroyDto.getSealNo());
                    operSealInfoDao.deleteBySealNo(sealDestroyDto.getSealNo());
                }
            } else if ("3".equals(sealDestroyDto.getHandoverType())) {
                sealHandoverEntity.setSealNo(sealDestroyDto.getSealNo());
                QueryModel model = new QueryModel();
                model.setCondition((Object)sealHandoverEntity);
                List<OperSealHandoverEntity> operSealHandoverEntities = this.operSealHandoverDao.selectByModel(model);
                for (OperSealHandoverEntity operSealHandoverEntity : operSealHandoverEntities) {
                    operSealHandoverEntity.setLogType("2");
                    this.operSealHandoverDao.updateByPrimaryKey(operSealHandoverEntity);
                }
                BeanUtils.beanCopy((Object)sealDestroyDto, (Object)sealHandoverEntity);
                sealHandoverEntity.setHandoverId(StringUtils.getUUID());
                sealHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
                sealHandoverEntity.setHandoverTime(DateUtils.formatDate((String)"HH:mm:ss"));
                sealHandoverEntity.setLastChangeUser(SessionUtils.getUserId());
                sealHandoverEntity.setLastChangeDate(DateUtils.formatDateTimeByDef());
                sealHandoverEntity.setLogType("1");
                this.operSealHandoverDao.insert(sealHandoverEntity);
                OperSealInfoEntity entity = new OperSealInfoEntity();
                entity.setSealId(sealDestroyDto.getSealId());
                entity.setSealState(sealDestroyDto.getHandoverType());
                entity.setSealNo(sealDestroyDto.getSealNo());
                entity.setSealName(sealDestroyDto.getSealName());
                entity.setCurrentOrgId(sealDestroyDto.getSrcOrgId());
                entity.setRemark(sealDestroyDto.getRemark());
                entity.setReciveUser(sealDestroyDto.getReciveUser());
                entity.setReciveAdminUser(sealDestroyDto.getReciveAdminUser());
                entity.setHandoverSupervisor(sealDestroyDto.getHandoverSupervisor());
                entity.setLastChangeUser(SessionUtils.getUserId());
                entity.setLastChangeDate(DateUtils.formatDateTimeByDef());
                operSealInfoDao.updateByPrimaryKey(entity);
            }
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }
}

