/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.OperGoodsInfoBo;
import cn.com.yusys.yusp.operation.dao.OperGoodsHandoverDao;
import cn.com.yusys.yusp.operation.dao.OperGoodsInfoDao;
import cn.com.yusys.yusp.operation.domain.dto.GoodsInfoDto;
import cn.com.yusys.yusp.operation.domain.dto.GoodsInfoList;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsHandoverEntity;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.OperGoodsInfoQuery;
import cn.com.yusys.yusp.operation.service.OperGoodsInfoService;
import cn.com.yusys.yusp.operation.service.impl.OperSealHandoverServiceImpl;
import cn.com.yusys.yusp.operation.vo.OperGoodsInfoVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperGoodsInfoServiceImpl
implements OperGoodsInfoService {
    private static final Logger logger = LoggerFactory.getLogger(OperSealHandoverServiceImpl.class);
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private OperGoodsInfoDao operGoodsInfoDao;
    @Autowired
    private OperGoodsHandoverDao operGoodsHandoverDao;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean create(IcspRequest<OperGoodsInfoBo> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsHandoverDao operGoodsHandoverDao = (OperGoodsHandoverDao)session.getMapper(OperGoodsHandoverDao.class);
        OperGoodsInfoBo operGoodsInfoBo = (OperGoodsInfoBo)request.getBody();
        boolean flag = false;
        try {
            OperGoodsInfoEntity operGoodsInfoEntity = new OperGoodsInfoEntity();
            BeanUtils.beanCopy((Object)operGoodsInfoBo, (Object)operGoodsInfoEntity);
            operGoodsInfoEntity.setGoodsId(StringUtils.getUUID());
            operGoodsInfoEntity.setRecord(operGoodsInfoBo.getRecord());
            operGoodsInfoEntity.setCreateUser(request.getTradeHead().getUserId());
            operGoodsInfoEntity.setCreateDate(request.getTradeHead().getWorkDate());
            operGoodsInfoEntity.setCreateTime(DateUtils.formatDate((String)"HH:mm:ss"));
            operGoodsInfoEntity.setLastChangeUser(SessionUtils.getUserId());
            operGoodsInfoEntity.setLastChangeDate(DateUtils.formatDateByDef());
            this.operGoodsInfoDao.insert(operGoodsInfoEntity);
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            goodsHandoverEntity.setOperType("1");
            goodsHandoverEntity.setGoodsId(operGoodsInfoBo.getGoodsId());
            goodsHandoverEntity.setCurrentOrgId(operGoodsInfoBo.getOrgId());
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setReciveUser(request.getTradeHead().getUserId());
            goodsHandoverEntity.setTogethrtAdminUser(operGoodsInfoBo.getTogethrtAdminUser());
            goodsHandoverEntity.setHandoverMatter(operGoodsInfoBo.getRemark());
            goodsHandoverEntity.setHandoverTime(operGoodsInfoEntity.getCreateTime());
            goodsHandoverEntity.setImageId(operGoodsInfoBo.getImageId());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            goodsHandoverEntity.setGoodsId(operGoodsInfoEntity.getGoodsId());
            operGoodsHandoverDao.insert(goodsHandoverEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public OperGoodsInfoVo show(OperGoodsInfoQuery operGoodsInfoQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operGoodsInfoQuery);
        List<OperGoodsInfoEntity> list = this.operGoodsInfoDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ goodsId=" + operGoodsInfoQuery.getGoodsId() + " ]");
        }
        OperGoodsInfoVo vo = new OperGoodsInfoVo();
        BeanUtils.beanCopy((Object)list.get(0), (Object)vo);
        return vo;
    }

    @Override
    public GoodsInfoDto index(OperGoodsInfoQuery operGoodsInfoQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operGoodsInfoQuery);
        List<OperGoodsInfoEntity> select = this.operGoodsInfoDao.selectByModel(model);
        model.setSize(size);
        model.setPage(page);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<OperGoodsInfoEntity> entities = this.operGoodsInfoDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(entities, GoodsInfoList.class);
        list.forEach(GoodsInfoList2 -> {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            goodsHandoverEntity.setGoodsId(GoodsInfoList2.getGoodsId());
            QueryModel model1 = new QueryModel();
            model1.setCondition((Object)goodsHandoverEntity);
            List<OperGoodsHandoverEntity> entityList = this.operGoodsHandoverDao.selectByModelDesc(model1);
            if (entityList.size() == 0) {
                GoodsInfoList2.setHandoverDate("");
            } else {
                GoodsInfoList2.setHandoverDate(entityList.get(0).getHandoverDate());
            }
        });
        GoodsInfoDto goodsInfoDto = new GoodsInfoDto();
        goodsInfoDto.setList(list);
        goodsInfoDto.setSize(select.size());
        PageHelper.clearPage();
        return goodsInfoDto;
    }

    @Override
    public List<OperGoodsInfoVo> list(QueryModel model) throws Exception {
        List<GoodsInfoDto> list = this.operGoodsInfoDao.selectDto(model);
        List listVo = (List)BeanUtils.beansCopy(list, OperGoodsInfoVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(IcspRequest<OperGoodsInfoBo> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsHandoverDao operGoodsHandoverDao = (OperGoodsHandoverDao)session.getMapper(OperGoodsHandoverDao.class);
        OperGoodsInfoBo operGoodsInfoBo = (OperGoodsInfoBo)request.getBody();
        boolean flag = false;
        try {
            OperGoodsInfoEntity operGoodsInfoEntity = new OperGoodsInfoEntity();
            BeanUtils.beanCopy((Object)operGoodsInfoBo, (Object)operGoodsInfoEntity);
            operGoodsInfoEntity.setRecord("1");
            operGoodsInfoEntity.setCreateUser(request.getTradeHead().getUserId());
            operGoodsInfoEntity.setCreateDate(request.getTradeHead().getWorkDate());
            operGoodsInfoEntity.setCreateTime(DateUtils.formatDate((String)"HH:mm"));
            operGoodsInfoEntity.setLastChangeUser(SessionUtils.getUserId());
            operGoodsInfoEntity.setLastChangeDate(DateUtils.formatDateByDef());
            this.operGoodsInfoDao.updateByPrimaryKey(operGoodsInfoEntity);
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            goodsHandoverEntity.setOperType("6");
            goodsHandoverEntity.setGoodsId(operGoodsInfoBo.getGoodsId());
            goodsHandoverEntity.setCurrentOrgId(operGoodsInfoBo.getOrgId());
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setReciveUser(request.getTradeHead().getUserId());
            goodsHandoverEntity.setTogethrtAdminUser(operGoodsInfoBo.getTogethrtAdminUser());
            goodsHandoverEntity.setHandoverMatter(operGoodsInfoBo.getRemark());
            goodsHandoverEntity.setHandoverTime(operGoodsInfoEntity.getCreateTime());
            goodsHandoverEntity.setImageId(operGoodsInfoBo.getImageId());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            operGoodsHandoverDao.insert(goodsHandoverEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public int delete(String goodsId) throws Exception {
        return this.operGoodsInfoDao.deleteByPrimaryKey(goodsId);
    }

    @Override
    public String createImageId() throws Exception {
        return StringUtils.getUUID();
    }
}

