/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.OperGoodsHandoverBo;
import cn.com.yusys.yusp.operation.dao.OperGoodsHandoverDao;
import cn.com.yusys.yusp.operation.dao.OperGoodsInfoDao;
import cn.com.yusys.yusp.operation.domain.dto.GoodsDestoryDto;
import cn.com.yusys.yusp.operation.domain.dto.GoodsHandoverDto;
import cn.com.yusys.yusp.operation.domain.dto.GoodsHandoverInfoDto;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsHandoverEntity;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.OperGoodsHandoverQuery;
import cn.com.yusys.yusp.operation.service.OperGoodsHandoverService;
import cn.com.yusys.yusp.operation.service.impl.OperSealHandoverServiceImpl;
import cn.com.yusys.yusp.operation.vo.OperGoodsHandoverVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperGoodsHandoverServiceImpl
implements OperGoodsHandoverService {
    private static final Logger logger = LoggerFactory.getLogger(OperSealHandoverServiceImpl.class);
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private OperGoodsHandoverDao operGoodsHandoverDao;

    @Override
    public int create(OperGoodsHandoverBo operGoodsHandoverBo) throws Exception {
        operGoodsHandoverBo.setHandoverId(StringUtils.getUUID());
        OperGoodsHandoverEntity operGoodsHandoverEntity = new OperGoodsHandoverEntity();
        BeanUtils.beanCopy((Object)operGoodsHandoverBo, (Object)operGoodsHandoverEntity);
        return this.operGoodsHandoverDao.insert(operGoodsHandoverEntity);
    }

    @Override
    public OperGoodsHandoverVo show(OperGoodsHandoverQuery operGoodsHandoverQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operGoodsHandoverQuery);
        List<OperGoodsHandoverEntity> operGoodsHandoverEntities = this.operGoodsHandoverDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(operGoodsHandoverEntities, OperGoodsHandoverVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ handoverId=" + operGoodsHandoverQuery.getHandoverId() + " ]");
        }
        return (OperGoodsHandoverVo)list.get(0);
    }

    @MyPageAble(returnVo=GoodsHandoverInfoDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<GoodsHandoverInfoDto> list = this.operGoodsHandoverDao.selectDtoByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<OperGoodsHandoverVo> list(QueryModel model) throws Exception {
        List<OperGoodsHandoverEntity> list = this.operGoodsHandoverDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, OperGoodsHandoverVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverTime(DateUtils.formatDate((String)"HH:mm:ss"));
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setTogethrtAdminUser(goodsHandoverDto.getTogethrtAdminUser());
            goodsInfoEntity.setCreateUser(goodsHandoverDto.getReciveUser());
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            goodsInfoEntity.setCreateDate(request.getTradeHead().getWorkDate());
            goodsInfoEntity.setLastChangeUser(SessionUtils.getUserId());
            goodsInfoEntity.setLastChangeDate(DateUtils.formatDateByDef());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(IcspRequest<GoodsDestoryDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsDestoryDto goodsDestoryDto = (GoodsDestoryDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            if ("4".equals(goodsDestoryDto.getRecord())) {
                goodsHandoverEntity.setGoodsId(goodsDestoryDto.getGoodsId());
                goodsHandoverEntity.setOperType("1");
                goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
                QueryModel model = new QueryModel();
                model.setCondition((Object)goodsHandoverEntity);
                List<OperGoodsHandoverEntity> operGoodsHandoverEntities = this.operGoodsHandoverDao.selectByModel(model);
                if (operGoodsHandoverEntities.size() == 0) {
                    throw new IcspException("500", "\u53ea\u5141\u8bb8\u6ce8\u9500\u5f53\u65e5\u5165\u5e93\u7269\u54c1");
                }
                if (operGoodsHandoverEntities.size() == 1) {
                    operGoodsInfoDao.deleteByPrimaryKey(goodsDestoryDto.getGoodsId());
                    this.operGoodsHandoverDao.deleteByGoodsId(goodsDestoryDto.getGoodsId());
                }
            } else if ("3".equals(goodsDestoryDto.getRecord())) {
                goodsHandoverEntity.setGoodsId(goodsDestoryDto.getGoodsId());
                goodsHandoverEntity.setOperType("3");
                goodsHandoverEntity.setHandOutUser(request.getTradeHead().getUserId());
                goodsHandoverEntity.setHandOutOrg(request.getTradeHead().getOrgId());
                goodsHandoverEntity.setHandoverMatter(goodsDestoryDto.getRemark());
                goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
                this.operGoodsHandoverDao.insert(goodsHandoverEntity);
                OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
                goodsInfoEntity.setGoodsId(goodsDestoryDto.getGoodsId());
                goodsInfoEntity.setRecord("2");
                goodsInfoEntity.setTogethrtAdminUser(goodsDestoryDto.getTogethrtAdminUser());
                goodsInfoEntity.setCreateDate(request.getTradeHead().getWorkDate());
                goodsInfoEntity.setLastChangeUser(SessionUtils.getUserId());
                goodsInfoEntity.setLastChangeDate(DateUtils.formatDateByDef());
                operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            }
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean forceRecover(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            goodsHandoverEntity.setOperType("4");
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setTogethrtAdminUser(goodsHandoverDto.getTogethrtAdminUser());
            goodsInfoEntity.setCreateUser(goodsHandoverDto.getReciveUser());
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            goodsInfoEntity.setCreateDate(request.getTradeHead().getWorkDate());
            goodsInfoEntity.setLastChangeUser(SessionUtils.getUserId());
            goodsInfoEntity.setLastChangeDate(DateUtils.formatDateByDef());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean restart(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            goodsHandoverEntity.setOperType("5");
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<GoodsHandoverInfoDto> list = this.operGoodsHandoverDao.selectDtoByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cGoodIdTitle = rowTitle.createCell(0);
        cGoodIdTitle.setCellValue("\u7269\u54c1\u7f16\u53f7");
        Cell cGoodsNameTitle = rowTitle.createCell(1);
        cGoodsNameTitle.setCellValue("\u7269\u54c1\u540d\u79f0");
        Cell cRecordTitle = rowTitle.createCell(2);
        cRecordTitle.setCellValue("\u7269\u54c1\u72b6\u6001");
        Cell cGoodsCatalTitle = rowTitle.createCell(3);
        cGoodsCatalTitle.setCellValue("\u7269\u54c1\u5206\u7c7b/\u5927\u7c7b");
        Cell cGoodsSubclassTitle = rowTitle.createCell(4);
        cGoodsSubclassTitle.setCellValue("\u7269\u54c1\u5b50\u7c7b");
        Cell cStartNoTitle = rowTitle.createCell(5);
        cStartNoTitle.setCellValue("\u8d77\u59cb\u53f7\u7801");
        Cell cEndNoTitle = rowTitle.createCell(6);
        cEndNoTitle.setCellValue("\u7ec8\u6b62\u53f7\u7801");
        Cell cGoodsNumTitle = rowTitle.createCell(7);
        cGoodsNumTitle.setCellValue("\u7269\u54c1\u6570\u91cf");
        Cell cImageIdTitle = rowTitle.createCell(8);
        cImageIdTitle.setCellValue("\u5f71\u50cf\u6807\u8bc6\u53f7");
        Cell cOperTypeTitle = rowTitle.createCell(9);
        cOperTypeTitle.setCellValue("\u64cd\u4f5c\u7c7b\u578b");
        Cell cHandoverDateTitle = rowTitle.createCell(10);
        cHandoverDateTitle.setCellValue("\u4ea4\u63a5\u65e5\u671f");
        Cell cHandoverTimeTitle = rowTitle.createCell(11);
        cHandoverTimeTitle.setCellValue("\u4ea4\u63a5\u65f6\u95f4");
        Cell cCurrentOrgIdTitle = rowTitle.createCell(12);
        cCurrentOrgIdTitle.setCellValue("\u63a5\u6536\u673a\u6784\u4ee3\u7801");
        Cell cReciveUserTitle = rowTitle.createCell(13);
        cReciveUserTitle.setCellValue("\u63a5\u6536\u67dc\u5458");
        Cell cTogethrtAdminUserTitle = rowTitle.createCell(14);
        cTogethrtAdminUserTitle.setCellValue("\u63a5\u6536\u5171\u7ba1\u4eba");
        Cell cSupervisorTitle = rowTitle.createCell(15);
        cSupervisorTitle.setCellValue("\u76d1\u4ea4\u4eba");
        Cell cHandOutOrgTitle = rowTitle.createCell(16);
        cHandOutOrgTitle.setCellValue("\u4ea4\u51fa\u5e93\u7ec4\u7ec7\u673a\u6784");
        Cell cHandOutUserTitle = rowTitle.createCell(17);
        cHandOutUserTitle.setCellValue("\u4ea4\u51fa\u67dc\u5458");
        Cell cHandoverTogethrtAdminUserTitle = rowTitle.createCell(18);
        cHandoverTogethrtAdminUserTitle.setCellValue("\u4ea4\u51fa\u5171\u7ba1\u4eba");
        Cell cHandoverMatterTitle = rowTitle.createCell(19);
        cHandoverMatterTitle.setCellValue("\u4ea4\u63a5\u4e8b\u7531");
        Cell cCrossFlagTitle = rowTitle.createCell(20);
        cCrossFlagTitle.setCellValue("\u662f\u5426\u8de8\u673a\u6784");
        Cell cHandoverIdTitle = rowTitle.createCell(21);
        cHandoverIdTitle.setCellValue("\u6d41\u6c34\u53f7");
        int num = 1;
        for (GoodsHandoverInfoDto goodsHandoverInfoDto : list) {
            HSSFRow row = sheet.createRow(num++);
            Cell cGoodId = row.createCell(0);
            cGoodId.setCellValue(goodsHandoverInfoDto.getGoodsId());
            Cell cGoodsName = row.createCell(1);
            cGoodsName.setCellValue(goodsHandoverInfoDto.getGoodsName());
            Cell cRecord = row.createCell(2);
            cRecord.setCellValue(goodsHandoverInfoDto.getRecord());
            Cell cGoodsCatal = row.createCell(3);
            cGoodsCatal.setCellValue(goodsHandoverInfoDto.getGoodsCatal());
            Cell cGoodsSubclass = row.createCell(4);
            cGoodsSubclass.setCellValue(goodsHandoverInfoDto.getGoodsSubclass());
            Cell cStartNo = row.createCell(5);
            cStartNo.setCellValue(goodsHandoverInfoDto.getStartNo());
            Cell cEndNo = row.createCell(6);
            cEndNo.setCellValue(goodsHandoverInfoDto.getEndNo());
            Cell cGoodsNum = row.createCell(7);
            cGoodsNum.setCellValue(goodsHandoverInfoDto.getGoodsNum());
            Cell cImageId = row.createCell(8);
            cImageId.setCellValue(goodsHandoverInfoDto.getImageId());
            Cell cOperType = row.createCell(9);
            cOperType.setCellValue(goodsHandoverInfoDto.getOperType());
            Cell cHandoverDate = row.createCell(10);
            cHandoverDate.setCellValue(goodsHandoverInfoDto.getHandoverDate());
            Cell cHandoverTime = row.createCell(11);
            cHandoverTime.setCellValue(goodsHandoverInfoDto.getHandoverTime());
            Cell cCurrentOrgId = row.createCell(12);
            cCurrentOrgId.setCellValue(goodsHandoverInfoDto.getCurrentOrgId());
            Cell cReciveUser = row.createCell(13);
            cReciveUser.setCellValue(goodsHandoverInfoDto.getReciveUser());
            Cell cTogethrtAdminUser = row.createCell(14);
            cTogethrtAdminUser.setCellValue(goodsHandoverInfoDto.getTogethrtAdminUser());
            Cell cSupervisor = row.createCell(15);
            cSupervisor.setCellValue(goodsHandoverInfoDto.getSupervisor());
            Cell cHandOutOrg = row.createCell(16);
            cHandOutOrg.setCellValue(goodsHandoverInfoDto.getHandOutOrg());
            Cell cHandOutUser = row.createCell(17);
            cHandOutUser.setCellValue(goodsHandoverInfoDto.getHandOutUser());
            Cell cHandoverTogethrtAdminUser = row.createCell(18);
            cHandoverTogethrtAdminUser.setCellValue(goodsHandoverInfoDto.getHandoverTogethrtAdminUser());
            Cell cHandoverMatter = row.createCell(19);
            cHandoverMatter.setCellValue(goodsHandoverInfoDto.getHandoverMatter());
            Cell cCrossFlag = row.createCell(20);
            cCrossFlag.setCellValue(goodsHandoverInfoDto.getCrossFlag());
            Cell cHandoverId = row.createCell(21);
            cHandoverId.setCellValue(goodsHandoverInfoDto.getHandoverId());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u7269\u54c1\u4ea4\u63a5\u65e5\u5fd7.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

