/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.GoodsMutexRuleBo;
import cn.com.yusys.yusp.operation.dao.GoodsMutexElementDao;
import cn.com.yusys.yusp.operation.dao.GoodsMutexRuleDao;
import cn.com.yusys.yusp.operation.dao.GoodsMutexRuleDetailDao;
import cn.com.yusys.yusp.operation.domain.entity.GoodsMutexElementEntity;
import cn.com.yusys.yusp.operation.domain.entity.GoodsMutexRuleDetailEntity;
import cn.com.yusys.yusp.operation.domain.entity.GoodsMutexRuleEntity;
import cn.com.yusys.yusp.operation.domain.query.GoodsMutexRuleQuery;
import cn.com.yusys.yusp.operation.service.GoodsMutexRuleService;
import cn.com.yusys.yusp.operation.vo.GoodsMutexElementVo;
import cn.com.yusys.yusp.operation.vo.GoodsMutexRuleVo;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoodsMutexRuleServiceImpl
implements GoodsMutexRuleService {
    private static final Logger logger = LoggerFactory.getLogger(GoodsMutexRuleServiceImpl.class);
    @Autowired
    private GoodsMutexElementDao goodsMutexElementDao;
    @Autowired
    private GoodsMutexRuleDao goodsMutexRuleDao;
    @Autowired
    private GoodsMutexRuleDetailDao goodsMutexRuleDetailDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public int create(GoodsMutexRuleBo goodsMutexRuleBo) throws Exception {
        goodsMutexRuleBo.setRuleId(StringUtils.getUUID());
        GoodsMutexRuleEntity goodsMutexRuleEntity = new GoodsMutexRuleEntity();
        BeanUtils.beanCopy((Object)goodsMutexRuleBo, (Object)goodsMutexRuleEntity);
        return this.goodsMutexRuleDao.insert(goodsMutexRuleEntity);
    }

    @Override
    public GoodsMutexRuleVo show(GoodsMutexRuleQuery goodsMutexRuleQuery) throws Exception {
        GoodsMutexRuleVo vo = new GoodsMutexRuleVo();
        QueryModel model = new QueryModel();
        model.setCondition((Object)goodsMutexRuleQuery);
        GoodsMutexRuleEntity goodsMutexRuleEntity = this.goodsMutexRuleDao.selectByModel(model).get(0);
        BeanUtils.beanCopy((Object)goodsMutexRuleEntity, (Object)vo);
        QueryModel model1 = new QueryModel();
        GoodsMutexRuleDetailEntity detailEntity = new GoodsMutexRuleDetailEntity();
        detailEntity.setRuleId(goodsMutexRuleQuery.getRuleId());
        model1.setCondition((Object)detailEntity);
        List<GoodsMutexRuleDetailEntity> mutexRuleDetailEntities = this.goodsMutexRuleDetailDao.selectByModel(model1);
        ArrayList vos = new ArrayList();
        mutexRuleDetailEntities.forEach(goodsMutexRuleDetailEntity -> {
            QueryModel model2 = new QueryModel();
            GoodsMutexElementEntity elementEntity = new GoodsMutexElementEntity();
            elementEntity.setElementId(goodsMutexRuleDetailEntity.getElementId());
            model2.setCondition((Object)elementEntity);
            GoodsMutexElementEntity entity = this.goodsMutexElementDao.selectByModel(model2).get(0);
            GoodsMutexElementVo elementVo = (GoodsMutexElementVo)BeanUtils.beanCopy((Object)entity, GoodsMutexElementVo.class);
            vos.add(elementVo);
        });
        vo.setElementList(vos);
        return vo;
    }

    @MyPageAble(returnVo=GoodsMutexRuleVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<GoodsMutexRuleEntity> list = this.goodsMutexRuleDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<GoodsMutexRuleVo> list(QueryModel model) throws Exception {
        List<GoodsMutexRuleEntity> list = this.goodsMutexRuleDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, GoodsMutexRuleVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(GoodsMutexRuleBo goodsMutexRuleBo) throws Exception {
        boolean flag;
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        GoodsMutexRuleDetailDao detailDao = (GoodsMutexRuleDetailDao)session.getMapper(GoodsMutexRuleDetailDao.class);
        try {
            GoodsMutexRuleEntity goodsMutexRuleEntity = new GoodsMutexRuleEntity();
            BeanUtils.beanCopy((Object)goodsMutexRuleBo, (Object)goodsMutexRuleEntity);
            this.goodsMutexRuleDao.updateByPrimaryKey(goodsMutexRuleEntity);
            List elementList = goodsMutexRuleBo.getElementList();
            elementList.forEach(element -> {
                GoodsMutexRuleDetailEntity detailEntity = new GoodsMutexRuleDetailEntity();
                detailEntity.setElementId(element.getElementId());
                detailEntity.setRuleId(goodsMutexRuleBo.getRuleId());
                detailEntity.setRuleDetailId(StringUtils.getUUID());
                detailDao.insert(detailEntity);
            });
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(String ruleId) throws Exception {
        boolean flag;
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        GoodsMutexRuleDetailDao detailDao = (GoodsMutexRuleDetailDao)session.getMapper(GoodsMutexRuleDetailDao.class);
        try {
            this.goodsMutexRuleDao.deleteByPrimaryKey(ruleId);
            detailDao.deleteByRuleId(ruleId);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }
}

