/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.OperSealInfoBo;
import cn.com.yusys.yusp.operation.dao.OperSealInfoDao;
import cn.com.yusys.yusp.operation.domain.entity.OperSealInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.OperSealInfoQuery;
import cn.com.yusys.yusp.operation.service.OperSealInfoService;
import cn.com.yusys.yusp.operation.vo.OperSealInfoVo;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperSealInfoServiceImpl
implements OperSealInfoService {
    private static final Logger logger = LoggerFactory.getLogger(OperSealInfoServiceImpl.class);
    @Autowired
    private OperSealInfoDao operSealInfoDao;

    @Override
    public int create(OperSealInfoBo operSealInfoBo) throws Exception {
        operSealInfoBo.setSealId(StringUtils.getUUID());
        OperSealInfoEntity operSealInfoEntity = new OperSealInfoEntity();
        BeanUtils.beanCopy((Object)operSealInfoBo, (Object)operSealInfoEntity);
        return this.operSealInfoDao.insert(operSealInfoEntity);
    }

    @Override
    public OperSealInfoVo show(OperSealInfoQuery operSealInfoQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operSealInfoQuery);
        List<OperSealInfoEntity> operSealInfoEntities = this.operSealInfoDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(operSealInfoEntities, OperSealInfoVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ sealId=" + operSealInfoQuery.getSealId() + " ]");
        }
        return (OperSealInfoVo)list.get(0);
    }

    @Override
    public OperSealInfoVo index(OperSealInfoQuery operSealInfoQuery) throws Exception {
        QueryModel model = new QueryModel();
        OperSealInfoEntity operSealInfoEntity = new OperSealInfoEntity();
        operSealInfoEntity.setSealNo(operSealInfoQuery.getSealNo());
        model.setCondition((Object)operSealInfoEntity);
        List<OperSealInfoEntity> list = this.operSealInfoDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5370\u7ae0\u7f16\u53f7");
        }
        if (StringUtils.isEmpty((CharSequence)list.get(0).getSealName()) || StringUtils.isEmpty((CharSequence)list.get(0).getCurrentOrgId())) {
            throw new IcspException("500", "\u8be5\u5370\u7ae0\u672a\u914d\u7f6e\u5370\u7ae0\u540d\u79f0\u6216\u673a\u6784\u53f7\uff0c\u8bf7\u8f93\u5165\u5408\u9002\u7684\u5370\u7ae0\u7f16\u53f7");
        }
        if (ObjectUtils.notEqual((Object)list.get(0).getCurrentOrgId(), (Object)operSealInfoQuery.getCurrentOrgId())) {
            logger.info("\u539f\u673a\u6784\u53f7\uff1a" + list.get(0).getCurrentOrgId());
            logger.info("\u64cd\u4f5c\u673a\u6784\u53f7\uff1a" + operSealInfoQuery.getCurrentOrgId());
            throw new IcspException("500", "\u8be5\u5370\u7ae0\u6240\u5c5e\u673a\u6784\u53f7\u4e0e\u5f53\u524d\u64cd\u4f5c\u673a\u6784\u4e0d\u5339\u914d\uff0c\u8bf7\u8f93\u5165\u5408\u9002\u7684\u5370\u7ae0\u7f16\u53f7");
        }
        OperSealInfoVo operSealInfoVo = (OperSealInfoVo)BeanUtils.beanCopy((Object)list.get(0), OperSealInfoVo.class);
        return operSealInfoVo;
    }

    @Override
    public List<OperSealInfoVo> list(QueryModel model) throws Exception {
        List<OperSealInfoEntity> list = this.operSealInfoDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, OperSealInfoVo.class);
        return listVo;
    }

    @Override
    public int update(OperSealInfoBo operSealInfoBo) throws Exception {
        OperSealInfoEntity operSealInfoEntity = new OperSealInfoEntity();
        BeanUtils.beanCopy((Object)operSealInfoBo, (Object)operSealInfoEntity);
        return this.operSealInfoDao.updateByPrimaryKey(operSealInfoEntity);
    }

    @Override
    public int delete(String sealId) throws Exception {
        return this.operSealInfoDao.deleteByPrimaryKey(sealId);
    }
}

