/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.OperGoodsHandoverBo;
import cn.com.yusys.yusp.operation.dao.OperGoodsHandoverDao;
import cn.com.yusys.yusp.operation.dao.OperGoodsInfoDao;
import cn.com.yusys.yusp.operation.domain.dto.GoodsDestoryDto;
import cn.com.yusys.yusp.operation.domain.dto.GoodsHandoverDto;
import cn.com.yusys.yusp.operation.domain.dto.GoodsHandoverInfoDto;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsHandoverEntity;
import cn.com.yusys.yusp.operation.domain.entity.OperGoodsInfoEntity;
import cn.com.yusys.yusp.operation.domain.query.OperGoodsHandoverQuery;
import cn.com.yusys.yusp.operation.service.OperGoodsHandoverService;
import cn.com.yusys.yusp.operation.service.impl.OperSealHandoverServiceImpl;
import cn.com.yusys.yusp.operation.vo.OperGoodsHandoverVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperGoodsHandoverServiceImpl
implements OperGoodsHandoverService {
    private static final Logger logger = LoggerFactory.getLogger(OperSealHandoverServiceImpl.class);
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private OperGoodsHandoverDao operGoodsHandoverDao;

    @Override
    public int create(OperGoodsHandoverBo operGoodsHandoverBo) throws Exception {
        operGoodsHandoverBo.setHandoverId(StringUtils.getUUID());
        OperGoodsHandoverEntity operGoodsHandoverEntity = new OperGoodsHandoverEntity();
        BeanUtils.beanCopy((Object)operGoodsHandoverBo, (Object)operGoodsHandoverEntity);
        return this.operGoodsHandoverDao.insert(operGoodsHandoverEntity);
    }

    @Override
    public OperGoodsHandoverVo show(OperGoodsHandoverQuery operGoodsHandoverQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)operGoodsHandoverQuery);
        List<OperGoodsHandoverEntity> operGoodsHandoverEntities = this.operGoodsHandoverDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(operGoodsHandoverEntities, OperGoodsHandoverVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ handoverId=" + operGoodsHandoverQuery.getHandoverId() + " ]");
        }
        return (OperGoodsHandoverVo)list.get(0);
    }

    @MyPageAble(returnVo=GoodsHandoverInfoDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<GoodsHandoverInfoDto> list = this.operGoodsHandoverDao.selectDtoByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<OperGoodsHandoverVo> list(QueryModel model) throws Exception {
        List<OperGoodsHandoverEntity> list = this.operGoodsHandoverDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, OperGoodsHandoverVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverTime(DateUtils.formatDate((String)"HH:mm:ss"));
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(IcspRequest<GoodsDestoryDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsDestoryDto goodsDestoryDto = (GoodsDestoryDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            if ("4".equals(goodsDestoryDto.getRecord())) {
                goodsHandoverEntity.setGoodsId(goodsDestoryDto.getGoodsId());
                goodsHandoverEntity.setOperType("1");
                goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
                QueryModel model = new QueryModel();
                model.setCondition((Object)goodsHandoverEntity);
                List<OperGoodsHandoverEntity> operGoodsHandoverEntities = this.operGoodsHandoverDao.selectByModel(model);
                if (operGoodsHandoverEntities.size() == 0) {
                    new IcspException("500", "\u53ea\u5141\u8bb8\u6ce8\u9500\u5f53\u65e5\u5165\u5e93\u7269\u54c1");
                } else if (operGoodsHandoverEntities.size() == 1) {
                    operGoodsInfoDao.deleteByPrimaryKey(goodsDestoryDto.getGoodsId());
                    this.operGoodsHandoverDao.deleteByGoodsId(goodsDestoryDto.getGoodsId());
                }
            } else if ("3".equals(goodsDestoryDto.getRecord())) {
                goodsHandoverEntity.setGoodsId(goodsDestoryDto.getGoodsId());
                goodsHandoverEntity.setOperType("3");
                goodsHandoverEntity.setHandOutUser(request.getTradeHead().getUserId());
                goodsHandoverEntity.setHandOutOrg(request.getTradeHead().getOrgId());
                goodsHandoverEntity.setHandoverMatter(goodsDestoryDto.getRemark());
                goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
                this.operGoodsHandoverDao.insert(goodsHandoverEntity);
                OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
                BeanUtils.beanCopy((Object)goodsDestoryDto, (Object)goodsInfoEntity);
                goodsInfoEntity.setRecord("2");
                operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            }
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean forceRecover(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean restart(IcspRequest<GoodsHandoverDto> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        OperGoodsInfoDao operGoodsInfoDao = (OperGoodsInfoDao)session.getMapper(OperGoodsInfoDao.class);
        GoodsHandoverDto goodsHandoverDto = (GoodsHandoverDto)request.getBody();
        boolean flag = false;
        try {
            OperGoodsHandoverEntity goodsHandoverEntity = new OperGoodsHandoverEntity();
            BeanUtils.beanCopy((Object)goodsHandoverDto, (Object)goodsHandoverEntity);
            goodsHandoverEntity.setHandoverDate(request.getTradeHead().getWorkDate());
            goodsHandoverEntity.setHandoverId(StringUtils.getUUID());
            this.operGoodsHandoverDao.insert(goodsHandoverEntity);
            OperGoodsInfoEntity goodsInfoEntity = new OperGoodsInfoEntity();
            goodsInfoEntity.setGoodsId(goodsHandoverDto.getGoodsId());
            goodsInfoEntity.setRecord("1");
            goodsInfoEntity.setOrgId(goodsHandoverDto.getCurrentOrgId());
            operGoodsInfoDao.updateByPrimaryKey(goodsInfoEntity);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<GoodsHandoverInfoDto> list = this.operGoodsHandoverDao.selectDtoByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cGoodIdTitle = rowTitle.createCell(0);
        cGoodIdTitle.setCellValue("\u7269\u54c1\u7f16\u53f7");
        Cell cGoodsNameTitle = rowTitle.createCell(1);
        cGoodsNameTitle.setCellValue("\u7269\u54c1\u540d\u79f0");
        Cell cOperTypeTitle = rowTitle.createCell(2);
        cOperTypeTitle.setCellValue("\u64cd\u4f5c\u7c7b\u578b");
        Cell cOrgIdTitle = rowTitle.createCell(3);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cStartNoTitle = rowTitle.createCell(4);
        cStartNoTitle.setCellValue("\u8d77\u59cb\u53f7\u7801");
        Cell cEndNoTitle = rowTitle.createCell(5);
        cEndNoTitle.setCellValue("\u7ec8\u6b62\u53f7\u7801");
        Cell cHandoverDateTitle = rowTitle.createCell(6);
        cHandoverDateTitle.setCellValue("\u4ea4\u63a5\u65e5\u671f");
        Cell cHandOutUserTitle = rowTitle.createCell(7);
        cHandOutUserTitle.setCellValue("\u4ea4\u51fa\u67dc\u5458");
        Cell cHandoverTogethrtAdminUserTitle = rowTitle.createCell(8);
        cHandoverTogethrtAdminUserTitle.setCellValue("\u4ea4\u51fa\u5171\u7ba1\u4eba");
        Cell cReciveUserTitle = rowTitle.createCell(9);
        cReciveUserTitle.setCellValue("\u63a5\u6536\u67dc\u5458");
        Cell cTogethrtAdminUserTitle = rowTitle.createCell(10);
        cTogethrtAdminUserTitle.setCellValue("\u63a5\u6536\u5171\u7ba1\u4eba");
        Cell cSupervisorTitle = rowTitle.createCell(11);
        cSupervisorTitle.setCellValue("\u76d1\u4ea4\u4eba");
        Cell cHandoverIdTitle = rowTitle.createCell(12);
        cHandoverIdTitle.setCellValue("\u6d41\u6c34\u53f7");
        int num = 1;
        for (GoodsHandoverInfoDto goodsHandoverInfoDto : list) {
            HSSFRow row = sheet.createRow(num++);
            Cell cGoodId = row.createCell(0);
            cGoodId.setCellValue(goodsHandoverInfoDto.getGoodsId());
            Cell cGoodsName = row.createCell(1);
            cGoodsName.setCellValue(goodsHandoverInfoDto.getGoodsName());
            Cell cOperType = row.createCell(2);
            cOperType.setCellValue(goodsHandoverInfoDto.getOperType());
            Cell cOrgId = row.createCell(3);
            cOrgId.setCellValue(goodsHandoverInfoDto.getOrgId());
            Cell cStartNo = row.createCell(4);
            cStartNo.setCellValue(goodsHandoverInfoDto.getStartNo());
            Cell cEndNo = row.createCell(5);
            cEndNo.setCellValue(goodsHandoverInfoDto.getEndNo());
            Cell cHandoverDate = row.createCell(6);
            cHandoverDate.setCellValue(goodsHandoverInfoDto.getHandoverDate());
            Cell cHandOutUser = row.createCell(7);
            cHandOutUser.setCellValue(goodsHandoverInfoDto.getHandOutUser());
            Cell cHandoverTogethrtAdminUser = row.createCell(8);
            cHandoverTogethrtAdminUser.setCellValue(goodsHandoverInfoDto.getHandoverTogethrtAdminUser());
            Cell cReciveUser = row.createCell(9);
            cReciveUser.setCellValue(goodsHandoverInfoDto.getReciveUser());
            Cell cTogethrtAdminUser = row.createCell(10);
            cTogethrtAdminUser.setCellValue(goodsHandoverInfoDto.getTogethrtAdminUser());
            Cell cSupervisor = row.createCell(11);
            cSupervisor.setCellValue(goodsHandoverInfoDto.getSupervisor());
            Cell cHandoverId = row.createCell(12);
            cHandoverId.setCellValue(goodsHandoverInfoDto.getHandoverId());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u7269\u54c1\u4ea4\u63a5\u65e5\u5fd7.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

