/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterfeitSafekeepBo;
import cn.com.yusys.yusp.operation.dao.BookCounterfeitSafekeepDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterfeitSafekeepEntity;
import cn.com.yusys.yusp.operation.domain.excel.BookCounterfeitSafekeepExcel;
import cn.com.yusys.yusp.operation.domain.query.BookCounterfeitSafekeepQuery;
import cn.com.yusys.yusp.operation.service.BookCounterfeitSafekeepService;
import cn.com.yusys.yusp.operation.vo.BookCounterfeitSafekeepVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterfeitSafekeepServiceImpl
implements BookCounterfeitSafekeepService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterfeitSafekeepServiceImpl.class);
    @Autowired
    private BookCounterfeitSafekeepDao bookCounterfeitSafekeepDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookCounterfeitSafekeepBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookCounterfeitSafekeepDao bookCounterfeitSafekeepDao = (BookCounterfeitSafekeepDao)session.getMapper(BookCounterfeitSafekeepDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookCounterfeitSafekeepBo -> {
                BookCounterfeitSafekeepEntity entity = (BookCounterfeitSafekeepEntity)BeanUtils.beanCopy((Object)bookCounterfeitSafekeepBo, BookCounterfeitSafekeepEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookCounterfeitSafekeepDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookCounterfeitSafekeepVo show(BookCounterfeitSafekeepQuery bookCounterfeitSafekeepQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterfeitSafekeepQuery);
        List<BookCounterfeitSafekeepEntity> entities = this.bookCounterfeitSafekeepDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(entities, BookCounterfeitSafekeepVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterfeitSafekeepQuery.getTradeId() + " ]");
        }
        return (BookCounterfeitSafekeepVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCounterfeitSafekeepVo.class)
    public List index(BookCounterfeitSafekeepQuery bookCounterfeitSafekeepQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getEndDate())) {
            bookCounterfeitSafekeepQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getStartDate())) {
            bookCounterfeitSafekeepQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookCounterfeitSafekeepQuery);
        List<BookCounterfeitSafekeepEntity> list = this.bookCounterfeitSafekeepDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterfeitSafekeepVo> list(QueryModel model) throws Exception {
        List<BookCounterfeitSafekeepEntity> list = this.bookCounterfeitSafekeepDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterfeitSafekeepVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterfeitSafekeepBo bookCounterfeitSafekeepBo) throws Exception {
        BookCounterfeitSafekeepEntity bookCounterfeitSafekeepEntity = new BookCounterfeitSafekeepEntity();
        BeanUtils.beanCopy((Object)bookCounterfeitSafekeepBo, (Object)bookCounterfeitSafekeepEntity);
        return this.bookCounterfeitSafekeepDao.updateByPrimaryKey(bookCounterfeitSafekeepEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterfeitSafekeepDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public List<BookCounterfeitSafekeepExcel> download(BookCounterfeitSafekeepQuery query) throws Exception {
        QueryModel model = new QueryModel();
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate("00000000");
        }
        model.setCondition((Object)query);
        List<BookCounterfeitSafekeepExcel> list = this.bookCounterfeitSafekeepDao.download(model);
        return list;
    }
}

