/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterPropagandaBo;
import cn.com.yusys.yusp.operation.dao.BookCounterPropagandaDao;
import cn.com.yusys.yusp.operation.domain.dto.BookCashDto;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterPropagandaEntity;
import cn.com.yusys.yusp.operation.domain.excel.BookCounterPropagandaExcel;
import cn.com.yusys.yusp.operation.domain.query.BookCounterPropagandaQuery;
import cn.com.yusys.yusp.operation.service.BookCounterPropagandaService;
import cn.com.yusys.yusp.operation.vo.BookCounterPropagandaVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterPropagandaServiceImpl
implements BookCounterPropagandaService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterPropagandaServiceImpl.class);
    @Autowired
    private BookCounterPropagandaDao bookCounterPropagandaDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public int create(IcspRequest<BookCashDto> request) throws Exception {
        List<BookCounterPropagandaBo> list = ((BookCashDto)request.getBody()).getPropagandaList();
        int count = 0;
        for (BookCounterPropagandaBo bookCounterPropagandaBo : list) {
            BookCounterPropagandaEntity bookCounterPropagandaEntity = new BookCounterPropagandaEntity();
            BeanUtils.beanCopy((Object)bookCounterPropagandaBo, (Object)bookCounterPropagandaEntity);
            bookCounterPropagandaEntity.setTradeDate(request.getTradeHead().getWorkDate());
            bookCounterPropagandaEntity.setOrgId(request.getTradeHead().getOrgId());
            bookCounterPropagandaEntity.setTradeId(StringUtils.getUUID());
            this.bookCounterPropagandaDao.insert(bookCounterPropagandaEntity);
            ++count;
        }
        return count;
    }

    @Override
    public BookCounterPropagandaVo show(BookCounterPropagandaQuery bookCounterPropagandaQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterPropagandaQuery);
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterPropagandaQuery.getTradeId() + " ]");
        }
        BookCounterPropagandaVo vo = (BookCounterPropagandaVo)BeanUtils.beanCopy((Object)list.get(0), BookCounterPropagandaVo.class);
        return vo;
    }

    @MyPageAble(returnVo=BookCounterPropagandaVo.class)
    public List index(IcspRequest<BookCounterPropagandaQuery> request) throws Exception {
        BookCounterPropagandaQuery query = (BookCounterPropagandaQuery)request.getBody();
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate("00000000");
        }
        QueryModel model = request.getQueryModel();
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterPropagandaVo> list(QueryModel model) throws Exception {
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterPropagandaVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterPropagandaBo bookCounterPropagandaBo) throws Exception {
        BookCounterPropagandaEntity bookCounterPropagandaEntity = new BookCounterPropagandaEntity();
        BeanUtils.beanCopy((Object)bookCounterPropagandaBo, (Object)bookCounterPropagandaEntity);
        return this.bookCounterPropagandaDao.updateByPrimaryKey(bookCounterPropagandaEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterPropagandaDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public List<BookCounterPropagandaExcel> download(QueryModel model) throws Exception {
        List<BookCounterPropagandaExcel> list = this.bookCounterPropagandaDao.download(model);
        return list;
    }
}

