/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.operation.bo.BookDamagedExchangeBo;
import cn.com.yusys.yusp.operation.domain.dto.BookCashDto;
import cn.com.yusys.yusp.operation.domain.excel.BookDamagedExchangeExcel;
import cn.com.yusys.yusp.operation.domain.query.BookDamagedExchangeQuery;
import cn.com.yusys.yusp.operation.service.BookDamagedExchangeService;
import cn.com.yusys.yusp.operation.vo.BookDamagedExchangeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bookDamagedExchange"})
@Api(tags={"BookDamagedExchangeResource"}, description="\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f")
public class BookDamagedExchangeController {
    private static final Logger logger = LoggerFactory.getLogger(BookDamagedExchangeController.class);
    @Autowired
    private BookDamagedExchangeService bookDamagedExchangeService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<BookCashDto> request) throws Exception {
        int result = this.bookDamagedExchangeService.create(request);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<BookDamagedExchangeVo> show(@RequestBody IcspRequest<BookDamagedExchangeQuery> request) throws Exception {
        BookDamagedExchangeVo result = this.bookDamagedExchangeService.show((BookDamagedExchangeQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<BookDamagedExchangeVo>> index(@RequestBody IcspRequest<BookDamagedExchangeQuery> request) throws Exception {
        List<BookDamagedExchangeVo> list = this.bookDamagedExchangeService.index(request);
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<BookDamagedExchangeVo>> list(@RequestBody IcspRequest<BookDamagedExchangeQuery> request) throws Exception {
        List<BookDamagedExchangeVo> list = this.bookDamagedExchangeService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<BookDamagedExchangeBo> request) throws Exception {
        int result = this.bookDamagedExchangeService.update((BookDamagedExchangeBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u91d1\u878d\u673a\u6784\u6b8b\u7f3a\u6c61\u635f\u4eba\u6c11\u5e01\u5151\u6362\u60c5\u51b5\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<BookDamagedExchangeBo> request) throws Exception {
        int result = this.bookDamagedExchangeService.delete(((BookDamagedExchangeBo)request.getBody()).getTradeId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<BookDamagedExchangeQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<BookDamagedExchangeExcel> list = this.bookDamagedExchangeService.download((BookDamagedExchangeQuery)request.getBody());
        File file = ExcelUtils.syncExport(BookDamagedExchangeExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

