/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.FileUtil;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterPropagandaBo;
import cn.com.yusys.yusp.operation.domain.dto.BookCashDto;
import cn.com.yusys.yusp.operation.domain.excel.BookCounterPropagandaExcel;
import cn.com.yusys.yusp.operation.domain.query.BookCounterPropagandaQuery;
import cn.com.yusys.yusp.operation.service.BookCounterPropagandaService;
import cn.com.yusys.yusp.operation.vo.BookCounterPropagandaVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bookCounterPropaganda"})
@Api(value="\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f")
public class BookCounterPropagandaController {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterPropagandaController.class);
    @Autowired
    private BookCounterPropagandaService bookCounterPropagandaService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<BookCashDto> request) throws Exception {
        int result = this.bookCounterPropagandaService.create(request);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<BookCounterPropagandaVo> show(@RequestBody IcspRequest<BookCounterPropagandaQuery> request) throws Exception {
        BookCounterPropagandaVo result = this.bookCounterPropagandaService.show((BookCounterPropagandaQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<BookCounterPropagandaVo>> index(@RequestBody IcspRequest<BookCounterPropagandaQuery> request) throws Exception {
        List<BookCounterPropagandaVo> list = this.bookCounterPropagandaService.index(request);
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<BookCounterPropagandaVo>> list(@RequestBody IcspRequest<BookCounterPropagandaQuery> request) throws Exception {
        List<BookCounterPropagandaVo> list = this.bookCounterPropagandaService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<BookCounterPropagandaBo> request) throws Exception {
        BookCounterPropagandaBo bookCounterPropagandaBo = (BookCounterPropagandaBo)request.getBody();
        int result = this.bookCounterPropagandaService.update(bookCounterPropagandaBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u53cd\u5ba3\u5e01\u6536\u5151\u767b\u8bb0\u7c3f")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<BookCounterPropagandaBo> request) throws Exception {
        BookCounterPropagandaBo bookCounterPropagandaBo = (BookCounterPropagandaBo)request.getBody();
        int result = this.bookCounterPropagandaService.delete(bookCounterPropagandaBo.getTradeId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u540c\u6b65\u5bfc\u51fa")
    public void download(@RequestBody IcspRequest<BookCounterPropagandaQuery> request, HttpServletResponse response) throws Exception {
        logger.debug("\u3010\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u540c\u6b65\u5bfc\u51fa\u6570\u636e\u3011");
        List<BookCounterPropagandaExcel> list = this.bookCounterPropagandaService.download(request.getQueryModel());
        File file = ExcelUtils.syncExport(BookCounterPropagandaExcel.class, list);
        byte[] bytes = FileUtil.file2byte((File)file);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

